/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.pages;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.BackToFollowUpStartPage;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.Names;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.ConnectedCompsTableContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.ConnectedCompsTableLabelProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches.ConnectedComponentSearchingSwitch;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches.ParentSearchSwitch;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ConnectedComponentsPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(ConnectedComponentsPage.class);
    private SAMMComponentProxy componentProxy;
    private Label initialComponentLabel;
    private Table connectedCompsTable;
    private TableViewer tableViewer;
    private SurfaceFactory factory = new SurfaceFactory();

    public ConnectedComponentsPage() {
        super("connectorsPage");
    }

    public void createControl(Composite parent) {
        this.setTitleAndTex();
        Composite frameComposite = this.factory.createCompositeOrGroup(parent, 3, 16384, 1, 0, true, 10, 10);
        this.createInitialComponentLabel(frameComposite);
        this.connectedCompsTable = this.factory.createTable(frameComposite, 1, Names.getHeadingsForConnectedCompsTable(), 4, true);
        this.factory.setGrabVerticalForGridData((Control)this.connectedCompsTable, true, 4);
        this.setTableViewer();
        Button button = new Button(frameComposite, 0);
        button.setText("back");
        button.addSelectionListener((SelectionListener)new BackToFollowUpStartPage((CalculateFollowUpWizard)this.getWizard()));
        this.setControl((Control)frameComposite);
    }

    private void setTitleAndTex() {
        this.setTitle("Connected Components");
        this.setMessage("Please select the components which are affected by an sgnature change in the component\n shown on the left side.");
    }

    public void setCurrentComponent(SAMMComponentProxy componentProxy) {
        this.componentProxy = componentProxy;
        this.updateTable();
    }

    private void setTableViewer() {
        this.tableViewer = new TableViewer(this.connectedCompsTable);
        this.tableViewer.setContentProvider((IContentProvider)new ConnectedCompsTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConnectedCompsTableLabelProvider());
    }

    private void updateTable() {
        try {
            this.initialComponentLabel.setText(this.componentProxy.getName());
            List<ComponentType> connectedComponentsList = this.getConnectedComponents();
            if (connectedComponentsList != null) {
                this.tableViewer.setInput(connectedComponentsList);
                this.tableViewer.refresh();
            }
            TableItem[] tableItemArray = this.connectedCompsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                TableEditor editor = new TableEditor(this.connectedCompsTable);
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                Button componentMarkingButton = new Button((Composite)this.connectedCompsTable, 0);
                componentMarkingButton.setText("Select");
                editor.setEditor((Control)componentMarkingButton, tableItem, 1);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createInitialComponentLabel(Composite frameComposite) {
        Composite compositeForInitialCompLabels = this.factory.createCompositeOrGroup(frameComposite, 1, 4, 1, 2048, false, 5, 5);
        Label textLabel = new Label(compositeForInitialCompLabels, 0);
        textLabel.setFont(SurfaceFactory.getFontStyle().get("textStyle"));
        textLabel.setText("The component you have chosen is: ");
        this.initialComponentLabel = new Label(compositeForInitialCompLabels, 0);
        this.initialComponentLabel.setFont(SurfaceFactory.getFontStyle().get("headingStyle"));
        this.initialComponentLabel.setText("When initialized, it is empty.");
    }

    private List<ComponentType> getConnectedComponents() {
        if (this.componentProxy != null) {
            CompositeStructure elementContainingComponent = this.getElementContainingComponent();
            ConnectedComponentSearchingSwitch connectedCompsSwitch = new ConnectedComponentSearchingSwitch(this.componentProxy.getComponenttype());
            connectedCompsSwitch.doSwitch((EObject)elementContainingComponent);
            return connectedCompsSwitch.getConnectedComponentsList();
        }
        return null;
    }

    private CompositeStructure getElementContainingComponent() {
        ParentSearchSwitch searchingSwitch = new ParentSearchSwitch(this.componentProxy);
        SAMMArchitectureModelProxy sammProxy = (SAMMArchitectureModelProxy)this.componentProxy.eContainer();
        ServiceArchitectureModel sammModel = sammProxy.getServicearchitecturemodel();
        for (SubcomponentInstance subInstance : sammModel.getSubcomponents()) {
            searchingSwitch.setCurrentParent((CompositeStructure)sammModel);
            searchingSwitch.doSwitch((EObject)subInstance.getRealizedBy());
            if (searchingSwitch.isElementFound()) break;
        }
        return searchingSwitch.getFoundParent();
    }
}

