/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workorganisation.listeners;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;

public class TeamComboListener
extends SelectionAdapter {
    private static final Logger logger = Logger.getLogger(TeamComboListener.class);
    private Combo teamCombo;
    private Combo roleCombo;
    private Label componentName;
    private SAMMComponentProxy component;
    private TableViewer assignedDevelopersViewer;

    public TeamComboListener(Combo teamCombo, Combo roleCombo, Label componentName, SAMMComponentProxy component, TableViewer assignedDevelopersViewer) {
        this.teamCombo = teamCombo;
        this.roleCombo = roleCombo;
        this.componentName = componentName;
        this.component = component;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        LinkedList<Object> rolesList = new LinkedList<Object>();
        this.roleCombo.setData(rolesList);
        if (this.teamCombo.getData() instanceof List) {
            List teams = (List)this.teamCombo.getData();
            this.roleCombo.removeAll();
            this.roleCombo.add("All");
            Team selectedTeam = (Team)teams.get(this.teamCombo.getSelectionIndex());
            for (SoftwareDeveloper developer : selectedTeam.getSoftwaredevelopers()) {
                this.roleCombo.add(developer.getName());
                rolesList.add(developer);
            }
            for (SoftwareArchitect architect : selectedTeam.getTeamarchitects()) {
                this.roleCombo.add(architect.getName());
                rolesList.add(architect);
            }
            this.assignedDevelopersViewer.setInput((Object)this.component.getWorkorganisationelement());
        }
        this.componentName.setText(this.component.getName());
        super.widgetSelected(e);
    }
}

