/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.kamp.ui.workplanediting.adapter.WorkPlanContentAdapter;
import de.fzi.kamp.ui.workplanediting.listeners.AddTopLevelActivitiesListener;
import de.fzi.kamp.ui.workplanediting.listeners.BackToAnalysisOverviewPageListener;
import de.fzi.kamp.ui.workplanediting.listeners.ContextMenuMouseListenerForWorkplanTree;
import de.fzi.kamp.ui.workplanediting.listeners.DeveloperStructureButtonListener;
import de.fzi.kamp.ui.workplanediting.listeners.LowestAbstractionListener;
import de.fzi.kamp.ui.workplanediting.listeners.WorkplanContainmentButtonListener;
import de.fzi.kamp.ui.workplanediting.listeners.WorkplanFollowUpButtonListener;
import de.fzi.kamp.ui.workplanediting.provider.WorkplanTableColumnConstants;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WorkplanTableLayer {
    private static final Logger logger = Logger.getLogger(WorkplanTableLayer.class);
    private List<Widget> widgets;
    private static final String BUTTONTEXT_LOWESTABSTRACTIONLEVEL = "Lowest Abstraction Level";
    private static final String BUTTONTEXT_DEVELOPERSTRUCTURE = "Developer Structure";
    private static final String BUTTONTEXT_CONTAINMENTRELATION = "Containment Relation";
    private static final String BUTTONTEXT_FOLLOW_UP_RELATION = "Follow-Up Relation";
    private static final String BUTTONTEXT_NAVIGATIONBUTTON = "Go back to Analysis Overview";
    private static final String BUTTONTEXT_ADDCHANGINGDOMAIN = "Add Composite Activity / Milestone";
    private static final String BUTTONTEXT_CALCULATE_FOLLOWUPS = "Calculate follow-ups";
    private static final String GROUPHEADING_RELATIONGROUP = "Show Activities in";
    private CentralEditorPage page;
    private WorkPlanContentAdapter adapter;
    private Display display;
    private boolean isEditableEffort;
    private ScrolledForm form;
    private Composite structureButtons;
    private IMainEditor mainEditor;
    private Group groupForButtons;
    private Button addCompositeButton;
    private Tree tree;
    private SurfaceFactory factory = new SurfaceFactory();

    public WorkplanTableLayer(CentralEditorPage page) {
        this.page = page;
        this.disposeWidgets();
    }

    public void disposeWidgets() {
        if (this.widgets != null && !this.widgets.isEmpty()) {
            for (Widget widget : this.widgets) {
                if (widget.isDisposed()) continue;
                widget.dispose();
            }
        }
        this.widgets = new ArrayList<Widget>();
    }

    public void createWorkplanTable(Display display, IMainEditor mainEditor, ScrolledForm form) {
        this.display = display;
        this.form = form;
        this.mainEditor = mainEditor;
        String[] headings = WorkplanTableColumnConstants.getHeadings();
        this.tree = this.factory.createTreeforEclipseForm(display, this.form.getBody(), headings, 128, true, 1, 450);
        this.tree.getColumn(10).setAlignment(0x1000000);
        this.widgets.add((Widget)this.tree);
        this.groupForButtons = new Group(this.form.getBody(), 0);
        this.widgets.add((Widget)this.groupForButtons);
        this.factory.configureCompositeForTableWrapLayout((Composite)this.groupForButtons, 3, 2, 1, false, this.factory.lookupColor(display, 255, 255, 255, "white"));
        this.adapter = new WorkPlanContentAdapter(this.tree, (ICommandHandler)this.mainEditor);
        this.createGroupForButtons(display, mainEditor);
        this.showEffortEstimationColumns();
        this.tree.addMouseListener((MouseListener)new ContextMenuMouseListenerForWorkplanTree(this.tree, mainEditor));
    }

    private void createGroupForButtons(Display display, IMainEditor mainEditor) {
        SelectionAdapter[] navigationListeners = new SelectionAdapter[]{new BackToAnalysisOverviewPageListener(mainEditor), new AddTopLevelActivitiesListener(mainEditor, this.tree)};
        this.factory.createButtonsForGivenTableWrapComposite((Composite)this.groupForButtons, new String[]{BUTTONTEXT_NAVIGATIONBUTTON, BUTTONTEXT_ADDCHANGINGDOMAIN}, 128, 0, true, navigationListeners, new Image[]{ActivityImageProvider.getArrowLeftIcon(), ActivityImageProvider.getIconForAddButton()});
        Control[] buttons = this.groupForButtons.getChildren();
        this.addCompositeButton = (Button)buttons[1];
        Control[] controlArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Control button = controlArray[n2];
            this.widgets.add((Widget)button);
            ++n2;
        }
    }

    public WorkPlanContentAdapter getAdapter() {
        return this.adapter;
    }

    private Composite createSelectStructureComposite() {
        FormToolkit toolkit = new FormToolkit(this.display);
        Group group = this.factory.createGroupWithWhiteBackgroundTableWrap(this.display, this.form.getBody(), GROUPHEADING_RELATIONGROUP, 8, false, 1, 4);
        group.setFont(SurfaceFactory.getFontStyle().getBold("groupStyle"));
        this.widgets.add((Widget)group);
        if (!this.isEditableEffort) {
            Button containment = toolkit.createButton((Composite)group, BUTTONTEXT_CONTAINMENTRELATION, 16);
            containment.addSelectionListener((SelectionListener)new WorkplanContainmentButtonListener(this.page, this.tree));
            containment.setSelection(true);
            Button followUp = toolkit.createButton((Composite)group, BUTTONTEXT_FOLLOW_UP_RELATION, 16);
            followUp.addSelectionListener((SelectionListener)new WorkplanFollowUpButtonListener(this.page, this.tree));
            this.widgets.add((Widget)containment);
            this.widgets.add((Widget)followUp);
        } else {
            Button lowestAbstractionButton = toolkit.createButton((Composite)group, BUTTONTEXT_LOWESTABSTRACTIONLEVEL, 32);
            Button isDeveloperStructureButton = toolkit.createButton((Composite)group, BUTTONTEXT_DEVELOPERSTRUCTURE, 32);
            lowestAbstractionButton.addSelectionListener((SelectionListener)new LowestAbstractionListener(this.page, this.tree, lowestAbstractionButton, isDeveloperStructureButton));
            isDeveloperStructureButton.addSelectionListener((SelectionListener)new DeveloperStructureButtonListener(this.mainEditor, this.tree, isDeveloperStructureButton));
            this.widgets.add((Widget)lowestAbstractionButton);
            this.widgets.add((Widget)isDeveloperStructureButton);
        }
        return group;
    }

    public void showEffortEstimationColumns() {
        if (this.structureButtons != null) {
            this.structureButtons.dispose();
        }
        this.structureButtons = this.createSelectStructureComposite();
        if (!this.tree.isDisposed()) {
            this.structureButtons.moveAbove((Control)this.tree);
            this.form.reflow(true);
        }
    }

    public void setIsEditableEffort(boolean isEditableEffort) {
        this.isEditableEffort = isEditableEffort;
    }

    public void setAddActivityAndCalcFollowUpsButtonsINVISIBLE() {
        if (!this.addCompositeButton.isDisposed()) {
            this.addCompositeButton.setEnabled(false);
            this.addCompositeButton.setGrayed(true);
        }
    }

    public void setAddActivityAndCalcFollowUpsButtonsVISIBLE() {
        if (!this.addCompositeButton.isDisposed()) {
            this.addCompositeButton.setEnabled(true);
            this.addCompositeButton.setGrayed(false);
        }
    }

    public void showDeveloperOrLowestAbstactionStructureView(Boolean showDeveloper) {
        if (showDeveloper.booleanValue()) {
            this.tree.getColumn(9).pack();
            this.tree.getColumn(9).setResizable(true);
        } else {
            TreeColumn[] treeColumnArray = this.tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (column.getText() == BUTTONTEXT_DEVELOPERSTRUCTURE || column.getText() == "Component" || column.getText() == "Interface Port" || column.getText() == "Operation") {
                    column.setWidth(0);
                } else {
                    column.pack();
                }
                ++n2;
            }
        }
    }

    public boolean isEditableEffort() {
        return this.isEditableEffort;
    }

    protected void finalize() throws Throwable {
        this.disposeWidgets();
        this.factory.cleanup();
        super.finalize();
    }
}

