/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceContentAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.SummaryTableContentAdapter;
import de.fzi.kamp.ui.analysisoverview.listeners.AddAnalysisInstanceSelectionListener;
import de.fzi.kamp.ui.analysisoverview.listeners.AnalysisInstanceRemoveArchitectureSelectionListener;
import de.fzi.kamp.ui.analysisoverview.listeners.ExportToResultmodelListener;
import de.fzi.kamp.ui.analysisoverview.listeners.ShowResultSummaryButtonListener;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceConstants;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceContentProvider;
import de.fzi.kamp.ui.analysisoverview.providers.AnalysisInstanceLabelProvider;
import de.fzi.kamp.ui.analysisoverview.providers.SummaryTableContentProvider;
import de.fzi.kamp.ui.analysisoverview.providers.SummaryTableLabelProvider;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.listeners.GoToArchitectureAlternativePageListener;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class AnalysisInstanceLayer {
    private static final Logger logger = Logger.getLogger(AnalysisInstanceLayer.class);
    private List<Widget> widgets;
    private SurfaceFactory factory;
    private Composite comp;
    private Display display;
    private Table table;
    private AnalysisManager analysisManager;
    private IMainEditor mainEditorUI;
    private TableViewer tableViewer;

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public AnalysisInstanceLayer() {
        this.disposeWidgets();
    }

    public void disposeWidgets() {
        if (this.widgets != null && !this.widgets.isEmpty()) {
            for (Widget widget : this.widgets) {
                widget.dispose();
            }
        }
        this.widgets = new ArrayList<Widget>();
    }

    public void createAnalysisInstancePage(AnalysisManager analysisManager, Display display, ScrolledForm form, IMainEditor mainEditorUI) {
        this.display = display;
        this.mainEditorUI = mainEditorUI;
        this.analysisManager = analysisManager;
        this.factory = new SurfaceFactory();
        this.comp = this.factory.createCompositeForEclipseForm(display, form.getBody(), 0, 128, true, 1, 1);
        this.widgets.add((Widget)this.comp);
        this.createAnalysisInstancesTable();
        this.factory.setSizeForControl((Composite)this.table, 0, 300, false);
        Section section = this.createButtonSection();
        this.table.moveBelow((Control)section);
        this.createSummaryTable();
    }

    private void createAnalysisInstancesTable() {
        this.table = this.factory.createTableForAnalysisInstanceLayer(this.display, this.comp, 67584, AnalysisInstanceConstants.getMainTableCaptions(), true, 128, 1);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 30;
            }
        });
        this.widgets.add((Widget)this.table);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new AnalysisInstanceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AnalysisInstanceLabelProvider());
        this.tableViewer.setInput((Object)this.analysisManager.getAnalysisModel());
        this.analysisManager.getAnalysisModel().eAdapters().add((Object)new AnalysisInstanceContentAdapter(this.table, this.tableViewer, this.analysisManager.getAnalysisInstanceManager(), this.mainEditorUI, this));
        this.table.getColumn(4).setAlignment(0x1000000);
        this.setWorkComplexityColumnInvisible(this.table);
    }

    private Section createSummaryTable() {
        Section section = this.factory.createSection(this.comp, "Result Summary", 256, 2, false, this.display, 1);
        section.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
        this.widgets.add((Widget)section);
        section.marginHeight = 10;
        Table summaryTable = this.factory.createTableWithToolkit(this.display, (Composite)section, 65536, AnalysisInstanceConstants.getSummaryTableCaptions(), false, 16384, 1);
        summaryTable.setHeaderVisible(false);
        summaryTable.setLinesVisible(false);
        this.widgets.add((Widget)summaryTable);
        summaryTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        TableViewer viewer = new TableViewer(summaryTable);
        viewer.setContentProvider((IContentProvider)new SummaryTableContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        viewer.setInput((Object)this.analysisManager.getAnalysisModel());
        this.factory.setSizeForControl((Composite)summaryTable, 0, 100, false);
        SummaryTableContentAdapter contentAdapter = new SummaryTableContentAdapter(summaryTable, viewer);
        this.analysisManager.getAnalysisModel().eAdapters().add((Object)contentAdapter);
        section.setClient((Control)summaryTable);
        return section;
    }

    private Section createButtonSection() {
        Section section = this.factory.createSection(this.comp, "Analysis Instance", 256, 2, false, this.display, 1);
        section.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
        this.widgets.add((Widget)section);
        SelectionAdapter[] listenerArray = new SelectionAdapter[]{new AddAnalysisInstanceSelectionListener(this.table, this.analysisManager), new AnalysisInstanceRemoveArchitectureSelectionListener(this.analysisManager, this.table)};
        section.setClient((Control)this.factory.createHorizontalButtonsForEclipseForm(this.display, (Composite)section, new String[]{"", ""}, listenerArray, 128, 4, false, new Image[]{ActivityImageProvider.getIconForAddButton(), ActivityImageProvider.getIconForDeleteButton()}, this.widgets));
        return section;
    }

    private void createNavigationButton(Section effortSummaryTableSection) {
        Composite comp = this.factory.createHorizontalButtonsForEclipseForm(this.display, this.comp, new String[]{"Preparation Page"}, new SelectionAdapter[]{new GoToArchitectureAlternativePageListener(this.mainEditorUI)}, 4, 4, false, new Image[]{ActivityImageProvider.getArrowLeftIcon()}, this.widgets);
        this.widgets.add((Widget)comp);
    }

    private void setWorkComplexityColumnInvisible(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.getText() == "Work Complexity") {
                column.setWidth(0);
                column.setResizable(false);
            }
            ++n2;
        }
    }

    private void createExportInResultModelButton(ScrolledForm form) {
        Button button = new Button(this.comp, 0);
        button.setImage(ActivityImageProvider.getIconForExportButton());
        button.setText("Export to result model");
        this.widgets.add((Widget)button);
        TableWrapData tableWrapData = new TableWrapData();
        tableWrapData.align = 2;
        tableWrapData.grabHorizontal = true;
        tableWrapData.colspan = 1;
        button.setLayoutData((Object)tableWrapData);
        button.addSelectionListener((SelectionListener)new ExportToResultmodelListener(this.analysisManager, this.mainEditorUI.getEditingDomain().getResourceSet(), this.mainEditorUI));
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private TableEditor createResultSummaryButton(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance, IMainEditor mainEditor) {
        Composite comp = this.factory.createButtonComposite((Composite)table);
        Button button = this.factory.createButton(comp, "Show", (SelectionAdapter)new ShowResultSummaryButtonListener(manager, instance, mainEditor));
        button.setEnabled(false);
        itemadapter.setShowResultSummaryButton(button);
        this.widgets.add((Widget)comp);
        this.widgets.add((Widget)button);
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor((Control)comp, item, column);
        editor.layout();
        return editor;
    }

    public void layout() {
        this.comp.getParent().layout(true, true);
        this.comp.getParent().redraw();
    }

    protected void finalize() throws Throwable {
        this.disposeWidgets();
        this.factory.cleanup();
        super.finalize();
    }
}

