/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.page;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.ICentralEditorPage;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.listeners.ExportToResultmodelListener;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.listeners.GoToAnalysisInstancePageListener;
import de.fzi.kamp.ui.maineditor.listeners.GoToArchitectureAlternativePageListener;
import de.fzi.kamp.ui.maineditor.listeners.GoToChangeScenarioPageListener;
import de.fzi.kamp.ui.maineditor.listeners.GoToWorkorganisationView;
import de.fzi.kamp.ui.maineditor.stacklayers.AnalysisInstanceLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.SpecifyArchitectureAlternativesLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.SpecifyChangeScenarioLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.WorkorganisationTreeLayer;
import de.fzi.kamp.ui.maineditor.stacklayers.WorkplanTableLayer;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CentralEditorPage
implements ICentralEditorPage {
    private static final Logger logger = Logger.getLogger(CentralEditorPage.class);
    private StackLayout stackLayout;
    private ScrolledForm analysisForm;
    private ScrolledForm workplanForm;
    private ScrolledForm architectureAlternativeForm;
    private ScrolledForm workorganisationForm;
    private ScrolledForm changeScenarioForm;
    private SpecifyArchitectureAlternativesLayer architectureAlternativeLayer;
    private SpecifyChangeScenarioLayer changeScenarioLayer;
    private WorkorganisationTreeLayer workorganisationLayer = new WorkorganisationTreeLayer();
    private AnalysisInstanceLayer analysisInstanceLayer;
    private WorkplanTableLayer workplanLayer;
    private SurfaceFactory factory;
    private FormToolkit toolkit;
    private Composite globalContainer;
    private IMainEditor editor;
    private Display display;
    private AnalysisManager analysisManager;
    private boolean effortEstimationSelected = false;

    public CentralEditorPage() {
        this.architectureAlternativeLayer = new SpecifyArchitectureAlternativesLayer();
        this.changeScenarioLayer = new SpecifyChangeScenarioLayer();
    }

    public Control createAnalysisAndWorkplanForm(AnalysisManager analysisManager, Display display, Composite container, IMainEditor editor) {
        this.display = display;
        this.factory = new SurfaceFactory();
        this.toolkit = new FormToolkit(display);
        this.editor = editor;
        this.analysisManager = analysisManager;
        ScrolledForm sourroundingScrolledForm = this.toolkit.createScrolledForm(container);
        sourroundingScrolledForm.getBody().setLayout((Layout)CentralEditorPage.createTableWrapLayout(0, 0, 0, 2, false));
        sourroundingScrolledForm.getBody().setBackground(this.factory.lookupColor(display, 210, 230, 255, "sScrolledForm"));
        sourroundingScrolledForm.getBody().setLayoutData((Object)new TableWrapData(256));
        Form navigationForm = CentralEditorPage.createNavigationForm(display, sourroundingScrolledForm.getBody(), this.factory, this.toolkit, "Navigation", 1, false);
        this.createPreparationSection(navigationForm);
        this.createAnalysisSection(navigationForm);
        this.globalContainer = new Composite(sourroundingScrolledForm.getBody(), 0);
        this.globalContainer.setLayoutData((Object)new TableWrapData(256));
        this.stackLayout = new StackLayout();
        this.globalContainer.setLayout((Layout)this.stackLayout);
        this.architectureAlternativeForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Specify Architecture Alternative(s)", 1, false);
        this.architectureAlternativeLayer.createArchitectureAlternativeLayer(analysisManager, editor, this.architectureAlternativeForm);
        this.changeScenarioForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Specify Change Scenario(s)", 1, false);
        this.changeScenarioLayer.createChangeScenarioLayer(analysisManager, editor, this.changeScenarioForm);
        this.createAnalysisInstancesLayer();
        this.createWorkplanLayer();
        this.workorganisationForm = CentralEditorPage.createForm(display, this.globalContainer, this.factory, this.toolkit, "Workorganisation", 1, false);
        this.workorganisationLayer.createWorkorganisationTree(analysisManager, display, this.factory, this.workorganisationForm, editor);
        this.stackLayout.topControl = this.architectureAlternativeForm;
        this.globalContainer.layout();
        return sourroundingScrolledForm;
    }

    private void createAnalysisInstancesLayer() {
        this.disposeAnalysisInstanceLayer();
        this.analysisForm = CentralEditorPage.createForm(this.display, this.globalContainer, this.factory, this.toolkit, "KAMP Analysis Overview", 1, false);
        this.analysisInstanceLayer = new AnalysisInstanceLayer();
        this.analysisInstanceLayer.createAnalysisInstancePage(this.analysisManager, this.display, this.analysisForm, this.editor);
    }

    private void disposeAnalysisInstanceLayer() {
        if (this.analysisForm != null && !this.analysisForm.isDisposed()) {
            this.analysisForm.dispose();
        }
        this.analysisForm = null;
        if (this.analysisInstanceLayer != null) {
            this.analysisInstanceLayer.disposeWidgets();
        }
        this.analysisInstanceLayer = null;
    }

    private void createWorkplanLayer() {
        this.disposeWorkplanLayer();
        this.workplanForm = CentralEditorPage.createForm(this.display, this.globalContainer, this.factory, this.toolkit, "Workplan Editor", 1, false);
        this.workplanLayer = new WorkplanTableLayer(this);
        this.workplanLayer.createWorkplanTable(this.display, this.editor, this.workplanForm);
        if (this.effortEstimationSelected) {
            this.workplanLayer.setIsEditableEffort(true);
            this.workplanLayer.showEffortEstimationColumns();
            this.workplanLayer.setAddActivityAndCalcFollowUpsButtonsINVISIBLE();
        } else {
            this.workplanLayer.setIsEditableEffort(false);
            this.workplanLayer.setAddActivityAndCalcFollowUpsButtonsVISIBLE();
        }
        this.effortEstimationSelected = false;
    }

    private void disposeWorkplanLayer() {
        if (this.workplanForm != null && !this.workplanForm.isDisposed()) {
            this.workplanForm.dispose();
        }
        this.workplanForm = null;
        if (this.workplanLayer != null) {
            this.workplanLayer.disposeWidgets();
        }
        this.workplanLayer = null;
    }

    private void createPreparationSection(Form form) {
        Section section = this.toolkit.createSection(form.getBody(), 322);
        section.setText("Preparation");
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayoutData((Object)new TableWrapData(256));
        sectionClient.setLayout((Layout)new GridLayout());
        this.factory.createButton(sectionClient, "Specify Architecture Alternative(s)", 0, ActivityImageProvider.getArrowRightIcon(), new GoToArchitectureAlternativePageListener(this.editor));
        this.factory.createButton(sectionClient, "Specify Change Scenario(s)", 0, ActivityImageProvider.getArrowRightIcon(), new GoToChangeScenarioPageListener(this.editor));
        this.factory.createButton(sectionClient, "Specify Workorganisation", 0, ActivityImageProvider.getArrowRightIcon(), new GoToWorkorganisationView(this.editor));
        section.setClient((Control)sectionClient);
    }

    private void createAnalysisSection(Form form) {
        Section section = this.toolkit.createSection(form.getBody(), 322);
        section.setText("Analysis");
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayoutData((Object)new TableWrapData(256));
        sectionClient.setLayout((Layout)new GridLayout());
        this.factory.createButton(sectionClient, "Analysis Overview", 0, ActivityImageProvider.getArrowRightIcon(), new GoToAnalysisInstancePageListener(this.editor));
        this.factory.createButton(sectionClient, "Export Results", 0, ActivityImageProvider.getIconForExportButton(), new ExportToResultmodelListener(this.analysisManager, this.editor.getEditingDomain().getResourceSet(), this.editor));
        section.setClient((Control)sectionClient);
    }

    public TreeViewer getWorkorganisationTreeViewer() {
        return this.workorganisationLayer.getWorkorganisationTreeViewer();
    }

    private static Form createNavigationForm(Display display, Composite container, SurfaceFactory factory, FormToolkit toolkit, String text, int numColums, boolean makeColumsEqualwidth) {
        Form form = toolkit.createForm(container);
        form.setForeground(factory.lookupColor(display, 0, 0, 100, "naviforeground"));
        form.setBackground(factory.lookupColor(display, 210, 230, 255, "navibackground"));
        form.setFont(SurfaceFactory.getFontStyle().get("editorpageheadingStyle"));
        form.setText(text);
        form.getBody().setLayout((Layout)CentralEditorPage.createTableWrapLayout(10, 10, 10, numColums, makeColumsEqualwidth));
        return form;
    }

    private static ScrolledForm createForm(Display display, Composite container, SurfaceFactory factory, FormToolkit toolkit, String text, int numColums, boolean makeColumsEqualwidth) {
        ScrolledForm form = toolkit.createScrolledForm(container);
        form.setForeground(factory.lookupColor(display, 0, 0, 100, "naviforeground"));
        form.setFont(SurfaceFactory.getFontStyle().get("editorpageheadingStyle"));
        form.setText(text);
        form.getBody().setLayout((Layout)CentralEditorPage.createTableWrapLayout(10, 10, 40, numColums, makeColumsEqualwidth));
        return form;
    }

    public static TableWrapLayout createTableWrapLayout(int topMargin, int leftMargin, int rightMargin, int numColumns, boolean makeColumnsEqualWidth) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = topMargin;
        layout.leftMargin = leftMargin;
        layout.rightMargin = rightMargin;
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        return layout;
    }

    public static TableWrapData configureTableWrapData(int align, boolean grabHorizontal, int colspan, boolean grabVertical, int valign) {
        TableWrapData twd = new TableWrapData();
        twd.align = align;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        twd.grabVertical = grabVertical;
        twd.valign = valign;
        return twd;
    }

    public void setArchitectureAlternativePageAsTopControl() {
        this.disposeAnalysisInstanceLayer();
        this.disposeWorkplanLayer();
        this.stackLayout.topControl = this.architectureAlternativeForm;
        this.globalContainer.layout();
    }

    public void setChangeScenarioPageAsTopControl() {
        this.disposeAnalysisInstanceLayer();
        this.disposeWorkplanLayer();
        this.stackLayout.topControl = this.changeScenarioForm;
        this.globalContainer.layout();
    }

    public void setWorkplanAsTopControl() {
        this.disposeAnalysisInstanceLayer();
        this.createWorkplanLayer();
        this.stackLayout.topControl = this.workplanForm;
        this.globalContainer.layout();
    }

    public void setAnalysisPageAsTopControl() {
        this.disposeWorkplanLayer();
        this.createAnalysisInstancesLayer();
        this.stackLayout.topControl = this.analysisForm;
        this.analysisInstanceLayer.getTableViewer().refresh();
        this.analysisInstanceLayer.getTableViewer().getTable().redraw();
        this.analysisInstanceLayer.getTableViewer().getTable().update();
        this.analysisInstanceLayer.getTableViewer().getTable().layout();
        this.analysisInstanceLayer.getTableViewer().getTable().layout(true, true);
        this.analysisInstanceLayer.getTableViewer().getTable().deselectAll();
        this.analysisInstanceLayer.getTableViewer().getTable().select(0);
        this.globalContainer.layout();
        this.analysisInstanceLayer.layout();
    }

    public void setWorkorganisationPageAsTopControl() {
        this.disposeAnalysisInstanceLayer();
        this.disposeWorkplanLayer();
        this.stackLayout.topControl = this.workorganisationForm;
        this.globalContainer.layout();
    }

    public void setViewForOpenedWorkplan(Workplan workplan, boolean followUp, boolean isEditableEffort, boolean lowestAbstraction) {
        if (this.workplanLayer != null && this.workplanForm != null) {
            this.workplanLayer.setIsEditableEffort(isEditableEffort);
            this.workplanForm.reflow(true);
            this.updateWorkplanTree(workplan, followUp, isEditableEffort, lowestAbstraction);
        }
    }

    public void showDeveloperStructure(boolean showDeveloper) {
        if (this.workplanLayer != null) {
            this.workplanLayer.showDeveloperOrLowestAbstactionStructureView(showDeveloper);
        }
    }

    public void updateWorkplanTree(Workplan workplan, boolean followUp, boolean isEditableEffort, boolean lowestAbstraction) {
        if (this.workplanLayer != null) {
            this.workplanLayer.getAdapter().update(workplan, followUp, isEditableEffort, lowestAbstraction);
        }
    }

    public void setAddCompositeActivityButtonVisible() {
        if (this.workplanLayer != null) {
            this.workplanLayer.setAddActivityAndCalcFollowUpsButtonsVISIBLE();
        }
    }

    public void setAddCompositeActivityButtonInvisible() {
        if (this.workplanLayer != null) {
            this.workplanLayer.setAddActivityAndCalcFollowUpsButtonsINVISIBLE();
        }
    }

    public WorkplanTableLayer getWorkplanLayer() {
        return this.workplanLayer;
    }

    public boolean effortEstimationViewIsActivated() {
        return this.effortEstimationSelected;
    }

    public void setEffortEstimationActivation(boolean active) {
        this.effortEstimationSelected = active;
    }
}

