/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.general;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.maineditor.MainEditorUI;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherDerivationWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.DeriveWorkPlanWizard;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class WizardManager
implements IWizardManager {
    private static final Logger logger = Logger.getLogger(WizardManager.class);

    public List<? extends ComponentSelectionContainer> showAddCompositeActivityWizard(EffortAnalysisInstance instance, Shell shell, IMainEditor editor, IArchitectureModelProvider architectureModelProvider) {
        DeriveWorkPlanWizard wizard = new DeriveWorkPlanWizard(instance, editor, architectureModelProvider);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.setPageSize(-1, 500);
        wizardDialog.create();
        wizardDialog.open();
        return wizard.getSelectedComponents();
    }

    public void showFurtherWorkplanDerivationWizard(Tree tree, IMainEditor editor) {
        logger.trace((Object)"showFurtherWorkplanDerivationWizard");
        FurtherDerivationWizard wizard = new FurtherDerivationWizard(tree, editor);
        WizardDialog wizardDialog = new WizardDialog(((MainEditorUI)editor).getSite().getShell(), (IWizard)wizard);
        wizardDialog.create();
        wizardDialog.open();
    }

    public void showCalculateFollowUpsWizard(Tree workplanTree, IMainEditor editor) {
        if (workplanTree.getSelectionCount() == 1) {
            TreeItem[] items = workplanTree.getSelection();
            if (items[0].getData() instanceof CompositeTask) {
                if (!(((CompositeTask)items[0].getData()).getSubtasks().get(0) instanceof CompositeTask)) {
                    CalculateFollowUpWizard followUpWizard = new CalculateFollowUpWizard(workplanTree);
                    WizardDialog wizardDialog = new WizardDialog(((MainEditorUI)editor).getSite().getShell(), (IWizard)followUpWizard);
                    wizardDialog.create();
                    wizardDialog.open();
                } else {
                    this.showErrorMessage("Please choose a composite activity for a concrete changing scenario\nand not the one for the whole workplan.", editor.getMainEditorShell());
                }
            } else {
                this.showErrorMessage("You have to choose an *composite activity*\nto start follow up calculation.", editor.getMainEditorShell());
            }
        } else {
            this.showErrorMessage("You have to choose an activity in the tree\n to start the follow up calculation.", editor.getMainEditorShell());
        }
    }

    public void showErrorMessage(String message, Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 1);
        messageBox.setText("Error");
        messageBox.setMessage(message);
        messageBox.open();
    }
}

