/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.dialog;

import de.fzi.kamp.service.analysisinstance.AnalysisAlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.architecturemodel.impl.BackboneModelLoader;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners.ArchitectureModelComboListener;
import de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners.ChangeRequestComboListener;
import de.fzi.kamp.ui.analysisoverview.dialog.dialoglisteners.StartingModelComboListener;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddAnalysisInstanceAndhangeRequestDialog
extends Dialog {
    private static final Logger logger = Logger.getLogger(AddAnalysisInstanceAndhangeRequestDialog.class);
    private MaintainabilityAnalysisModel analysisModel;
    private Combo comboAlternatives;
    private Combo comboChangeRequests;
    private Combo comboForStartingModel;
    private AnalysisAlternativeAndChangeRequestTuple result;
    private IArchitectureModelProvider architectureModelProvider;
    private List<IQAlternative> parentAlternativesOfSelectedAlternative;
    private IMainEditor mainEditor;
    private IQAlternative sourceIQAlternative;

    public AddAnalysisInstanceAndhangeRequestDialog(IMainEditor mainEditor, MaintainabilityAnalysisModel analysisModel, AnalysisAlternativeAndChangeRequestTuple result, IArchitectureModelProvider architectureModelProvider) {
        super(mainEditor.getMainEditorShell());
        this.mainEditor = mainEditor;
        this.analysisModel = analysisModel;
        this.result = result;
        this.architectureModelProvider = architectureModelProvider;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose Analysis Instance");
        Rectangle rec = shell.getDisplay().getBounds();
        int shellWidth = 320;
        int shellHeight = 270;
        int indentionLeft = (rec.width - shellWidth) / 2;
        int indentionTop = (rec.height - shellHeight) / 2;
        shell.setBounds(indentionLeft, indentionTop, shellWidth, shellHeight);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Composite area = (Composite)this.getDialogArea();
        this.setLayout(area);
        this.createLabel(area, "Architecture Alternative (target model):");
        this.comboAlternatives = new Combo(area, 8);
        this.setLayoutData(this.comboAlternatives);
        for (ArchitecturalAlternative alternative : this.analysisModel.getArchitecturealternatives()) {
            this.comboAlternatives.add(alternative.getName());
        }
        if (this.comboAlternatives.getItemCount() > 0) {
            this.comboAlternatives.select(0);
        }
        this.createLabel(area, "Change Request:");
        this.comboChangeRequests = new Combo(area, 8);
        this.setLayoutData(this.comboChangeRequests);
        for (ChangeRequest changeRequest : this.analysisModel.getChangerequests()) {
            if (changeRequest.isAutomaticDerivation()) {
                this.comboChangeRequests.add(String.valueOf(changeRequest.getName()) + " (automated)");
                continue;
            }
            this.comboChangeRequests.add(changeRequest.getName());
        }
        this.createLabel(area, "Source model");
        this.comboForStartingModel = new Combo(area, 8);
        this.comboForStartingModel.setEnabled(false);
        this.setLayoutData(this.comboForStartingModel);
        StartingModelComboListener startingModelListener = new StartingModelComboListener(this.comboForStartingModel, this);
        this.comboForStartingModel.addSelectionListener((SelectionListener)startingModelListener);
        ChangeRequestComboListener changeRequestComboListener = new ChangeRequestComboListener(this.comboAlternatives, this.comboChangeRequests, this.comboForStartingModel, this.analysisModel, this, startingModelListener);
        this.comboChangeRequests.addSelectionListener((SelectionListener)changeRequestComboListener);
        this.comboAlternatives.addSelectionListener((SelectionListener)new ArchitectureModelComboListener(changeRequestComboListener));
        if (this.comboChangeRequests.getItemCount() > 0) {
            this.comboChangeRequests.select(0);
            this.comboChangeRequests.notifyListeners(13, null);
        }
        return control;
    }

    protected void okPressed() {
        ArchitecturalAlternative sourceAlternative;
        int selectionIndexTargetAlternative = this.comboAlternatives.getSelectionIndex();
        this.result.targetArchitectureAlternative = (ArchitecturalAlternative)this.analysisModel.getArchitecturealternatives().get(selectionIndexTargetAlternative);
        int selectionIndexCR = this.comboChangeRequests.getSelectionIndex();
        this.result.changeRequest = (ChangeRequest)this.analysisModel.getChangerequests().get(selectionIndexCR);
        if (this.result.changeRequest.isAutomaticDerivation() && this.parentAlternativesOfSelectedAlternative != null && this.parentAlternativesOfSelectedAlternative.size() > 0 && this.sourceIQAlternative != null && (sourceAlternative = BackboneModelLoader.lookupArchitecturalAlternativeForIQAlternative((IQAlternative)this.sourceIQAlternative, (List)this.analysisModel.getArchitecturealternatives())) != null) {
            this.result.sourceArchitectureAlternative = sourceAlternative;
        }
        super.okPressed();
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void setLayout(Composite comp) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        comp.setLayout((Layout)gl);
    }

    private void setLayoutData(Combo combo) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        combo.setLayoutData((Object)gd);
    }

    public void fillStartingModelComboWithParentModels(ArchitecturalAlternative selectedArchiAlt) {
        IQModel iQModelOfSelectedModel = BackboneModelLoader.findIQModelForAlternativeName((String)selectedArchiAlt.getName(), (IMainEditor)this.mainEditor);
        if (iQModelOfSelectedModel != null) {
            this.parentAlternativesOfSelectedAlternative = new LinkedList<IQAlternative>();
            IQElement possibleParentAlternative = iQModelOfSelectedModel.getAlternative().getParent();
            this.fillParentModelList(this.parentAlternativesOfSelectedAlternative, possibleParentAlternative);
            this.comboForStartingModel.removeAll();
            for (IQAlternative parent : this.parentAlternativesOfSelectedAlternative) {
                this.comboForStartingModel.add(parent.getInfo().getDescription());
            }
        }
    }

    private void fillParentModelList(List<IQAlternative> parentAlternatives, IQElement possibleParentAlternative) {
        if (possibleParentAlternative instanceof IQAlternative) {
            parentAlternatives.add((IQAlternative)possibleParentAlternative);
            if (possibleParentAlternative.getParent() != null) {
                this.fillParentModelList(parentAlternatives, possibleParentAlternative.getParent());
            }
        }
    }

    public void setSourceIQModel(int selectionIndex) {
        this.sourceIQAlternative = this.parentAlternativesOfSelectedAlternative.get(selectionIndex);
    }
}

