/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.adapters;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.analysisoverview.listeners.CalculateButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.DeriveButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditEffortEstimationButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditWorkplanButtonListener;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.stacklayers.AnalysisInstanceLayer;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class AnalysisInstanceContentAdapter
extends EContentAdapter {
    private static final Logger logger = Logger.getLogger(AnalysisInstanceContentAdapter.class);
    private Table table;
    private List<TableEditor> tableEditorList;
    private IAnalysisInstanceManager manager;
    private TableViewer tableViewer;
    private SurfaceFactory surfaceFactory;
    private IMainEditor editor;
    private AnalysisInstanceLayer analysisInstanceLayer;

    public AnalysisInstanceContentAdapter(Table table, TableViewer tableViewer, IAnalysisInstanceManager manager, IMainEditor editor, AnalysisInstanceLayer analysisInstanceLayer) {
        this.table = table;
        this.editor = editor;
        this.manager = manager;
        this.tableViewer = tableViewer;
        this.tableEditorList = new LinkedList<TableEditor>();
        this.surfaceFactory = new SurfaceFactory();
        this.analysisInstanceLayer = analysisInstanceLayer;
        this.update();
    }

    public void notifyChanged(Notification notification) {
        if (notification == null) {
            this.update();
        } else if (notification.getFeatureID(MaintainabilityAnalysisModel.class) == 5 || notification.getFeatureID(MaintainabilityAnalysisModel.class) == 6) {
            this.update();
        }
        super.notifyChanged(notification);
    }

    private void update() {
        this.disposeTableEditors();
        if (!this.table.isDisposed()) {
            this.tableViewer.refresh();
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                this.tableEditorList = this.addButtonsToOverviewTable(item, this.manager, this, this.editor);
                ++n2;
            }
            tableItemArray = this.table.getColumns();
            n = tableItemArray.length;
            n2 = 0;
            while (n2 < n) {
                TableItem c = tableItemArray[n2];
                c.pack();
                if (c.getText().equals("Result Summary")) {
                    c.setWidth(130);
                }
                ++n2;
            }
        }
        this.layoutTableEditors();
    }

    private void disposeTableEditors() {
        for (TableEditor tableEditor : this.tableEditorList) {
            if (tableEditor.getEditor() != null) {
                tableEditor.getEditor().dispose();
            }
            if (tableEditor.getItem() != null) {
                tableEditor.getItem().dispose();
            }
            tableEditor.dispose();
        }
        this.tableEditorList = new ArrayList<TableEditor>();
    }

    public void layoutTableEditors() {
        for (TableEditor tableEditor : this.tableEditorList) {
            if (tableEditor.getEditor().isDisposed()) continue;
            tableEditor.layout();
        }
    }

    public List<TableEditor> getTableEditorList() {
        return this.tableEditorList;
    }

    public List<TableEditor> addButtonsToOverviewTable(TableItem item, IAnalysisInstanceManager manager, AnalysisInstanceContentAdapter contentAdapter, IMainEditor editor) {
        ArrayList<TableEditor> tableEditorList = new ArrayList<TableEditor>();
        if (item.getData() instanceof EffortAnalysisInstance) {
            EffortAnalysisInstance analysisInstance = (EffortAnalysisInstance)item.getData();
            AnalysisInstanceItemAdapter itemadapter = new AnalysisInstanceItemAdapter(manager, analysisInstance);
            analysisInstance.eAdapters().add((Object)itemadapter);
            tableEditorList.add(this.createWorkPlanButtons(item, 2, item.getParent(), manager, contentAdapter, analysisInstance, itemadapter, editor));
            tableEditorList.add(this.createEffortEstimationButtons(item, 3, item.getParent(), manager, itemadapter, analysisInstance, editor));
        }
        return tableEditorList;
    }

    private TableEditor createWorkPlanButtons(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceContentAdapter contentAdapter, EffortAnalysisInstance instance, AnalysisInstanceItemAdapter itemadapter, IMainEditor mainEditor) {
        TableEditor editor = new TableEditor(table);
        Composite comp = this.surfaceFactory.createButtonComposite((Composite)table);
        Button derive = this.surfaceFactory.createButton(comp, ActivityImageProvider.getRunIcon(), (SelectionAdapter)new DeriveButtonListener(manager, instance, mainEditor));
        Button edit = this.surfaceFactory.createButton(comp, ActivityImageProvider.getIconForEditButton(), (SelectionAdapter)new EditWorkplanButtonListener(manager, instance, mainEditor));
        itemadapter.setDeriveWorkplanButton(derive);
        itemadapter.setEditWorkspaceButton(edit);
        editor.setEditor((Control)comp, item, column);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.layout();
        return editor;
    }

    private TableEditor createEffortEstimationButtons(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance, IMainEditor mainEditor) {
        TableEditor editor = new TableEditor(table);
        Composite comp = this.surfaceFactory.createButtonComposite((Composite)table);
        this.analysisInstanceLayer.getWidgets().add((Widget)comp);
        Button editButton = this.surfaceFactory.createButton(comp, ActivityImageProvider.getIconForEditButton(), (SelectionAdapter)new EditEffortEstimationButtonListener(manager, instance, mainEditor));
        editButton.setEnabled(false);
        this.analysisInstanceLayer.getWidgets().add((Widget)editButton);
        itemadapter.setEffortEstimationEditButton(editButton);
        editor.setEditor((Control)comp, item, column);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.layout();
        return editor;
    }

    private TableEditor createWorkComplexityButton(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance, IMainEditor mainEditor) {
        Composite comp = this.surfaceFactory.createButtonComposite((Composite)table);
        Button button = this.surfaceFactory.createButton(comp, "Calculate", (SelectionAdapter)new CalculateButtonListener(manager, instance, mainEditor));
        button.setEnabled(false);
        itemadapter.setCalculateWorkcomplexityButton(button);
        this.analysisInstanceLayer.getWidgets().add((Widget)comp);
        this.analysisInstanceLayer.getWidgets().add((Widget)button);
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor((Control)comp, item, column);
        editor.layout();
        return editor;
    }
}

