/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.derivation;

import de.fzi.kamp.derivation.DiffWorkplanBuilder;
import de.fzi.kamp.derivation.IArchitectureModelResolver;
import de.fzi.kamp.derivation.IContainerFactory;
import de.fzi.kamp.derivation.IWorkplanBuilderResolver;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import java.io.IOException;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;

public class WorkplanDerivationJob
implements IJob {
    private static final Logger logger = Logger.getLogger(WorkplanDerivationJob.class);
    public static final String SAMM_SERVICEARCHITECTUREMODEL = "samm_servicearchitecturemodel";
    public static final String SAMM_REPOSITORY = "samm_repository";
    public static final String SAMM_SEFF = "samm_seff";
    public static final String SAMM_HARDWARE = "samm_hardware";
    public static final String SAMM_QOSANNOTATION = "samm_qosannotation";
    public static final String SAMM_USAGEMODEL = "samm_usagemodel";
    public static final String SAMM_TARGETENVIRONMENT = "samm_targetenvironment";
    private IQAlternative sourceAlternative;
    private IQAlternative targetAlternative;
    private EffortAnalysisInstance analysisInstance;
    private IArchitectureModelResolver architectureModelResolver;
    private IContainerFactory containerFactory;
    private IWorkplanBuilderResolver builderSolver;
    private DiffWorkplanBuilder workplanBuilder;

    public WorkplanDerivationJob(IQAlternative sourceAlternative, IQAlternative targetAlternative, EffortAnalysisInstance analysisInstance, IArchitectureModelResolver architectureModelResolver, IContainerFactory containerFactory, IWorkplanBuilderResolver builderSolver) {
        this.sourceAlternative = sourceAlternative;
        this.targetAlternative = targetAlternative;
        this.analysisInstance = analysisInstance;
        this.architectureModelResolver = architectureModelResolver;
        this.containerFactory = containerFactory;
        this.builderSolver = builderSolver;
    }

    public String getName() {
        return "KAMP Workplan Derivation";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.sourceAlternative == null) {
            logger.error((Object)"SourceAlternative was null");
            return;
        }
        if (this.targetAlternative == null) {
            logger.error((Object)"TargetAlternative was null");
            return;
        }
        try {
            logger.info((Object)"Run KAMP Workplan Derivation!");
            this.deriveWorkplanForAlternatives(this.sourceAlternative, this.targetAlternative);
        }
        catch (Exception e) {
            throw new JobFailedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void deriveWorkplanForAlternatives(IQAlternative sourceAlternative, IQAlternative targetAlternative) {
        String[] analysedModelTypes;
        String[] stringArray = analysedModelTypes = new String[]{SAMM_REPOSITORY};
        int n = analysedModelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String modelType = stringArray[n2];
            logger.info((Object)("Analysing model type: " + modelType));
            IQModel targetModel = this.getModelOfType(targetAlternative, modelType);
            IQModel sourceModel = this.getModelOfType(sourceAlternative, modelType);
            if (targetModel != null && sourceModel != null) {
                this.matchAndDiffModels(sourceModel, targetModel, modelType);
            }
            ++n2;
        }
    }

    private void matchAndDiffModels(IQModel sourceModel, IQModel targetModel, String modelType) {
        MatchModel match;
        IResource sourceResource = sourceModel.getCorrespondingResource();
        IResource targetResource = targetModel.getCorrespondingResource();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EObject sourceEObject = null;
        EObject targetEObject = null;
        try {
            sourceEObject = ModelUtils.load((URI)this.createURI(sourceResource), (ResourceSet)resourceSet);
            targetEObject = ModelUtils.load((URI)this.createURI(targetResource), (ResourceSet)resourceSet);
        }
        catch (IOException e) {
            throw new RuntimeException("Load of SourceModel or TargetModel failed", e);
        }
        if (sourceEObject != null && targetEObject != null && (match = this.calculateMatch(sourceEObject, targetEObject)) != null) {
            DiffModel diff = DiffService.doDiff((MatchModel)match);
            String filePath = String.valueOf(targetResource.getFullPath().removeLastSegments(1).addTrailingSeparator().toString()) + modelType + ".emfdiff";
            WorkplanDerivationJob.saveEmfModelToResource((EObject)diff, filePath, (ResourceSet)resourceSet);
            this.examineDiffModel(diff);
        }
    }

    private void examineDiffModel(DiffModel diff) {
        this.initializeWorkplanBuilder(diff);
        this.workplanBuilder.buildWorkplanFromDiffResult();
    }

    private void initializeWorkplanBuilder(DiffModel diff) {
        if (this.workplanBuilder == null) {
            this.workplanBuilder = new DiffWorkplanBuilder(diff, this.analysisInstance, this.architectureModelResolver, this.containerFactory, this.builderSolver);
        }
    }

    private URI createURI(IResource sourceResource) {
        String fullpath = sourceResource.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)fullpath, (boolean)false);
        return uri;
    }

    private MatchModel calculateMatch(EObject sourceEObject, EObject targetEObject) {
        MatchModel match = null;
        try {
            match = MatchService.doMatch((EObject)targetEObject, (EObject)sourceEObject, null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Matching was interrupted", e);
        }
        return match;
    }

    private IQModel getModelOfType(IQAlternative alternative, String modelType) {
        IQModel[] models;
        IQModel[] iQModelArray = models = alternative.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel model = iQModelArray[n2];
            if (model.getType().equals(modelType)) {
                return model;
            }
            ++n2;
        }
        return null;
    }

    private IQAlternative getAlternativeFromSelection(ISelection selection) {
        Object firstElement;
        if (selection != null && selection instanceof TreeSelection && (firstElement = ((TreeSelection)selection).getFirstElement()) != null && firstElement instanceof IQAlternative) {
            return (IQAlternative)firstElement;
        }
        return null;
    }

    private IQAlternative determineParentAlternative(IQAlternative selectedAlternative) {
        IQElement parentElement;
        if (selectedAlternative != null && (parentElement = selectedAlternative.getParent()) != null && parentElement instanceof IQAlternative) {
            return (IQAlternative)parentElement;
        }
        return null;
    }

    public static void saveEmfModelToResource(EObject model, String filePath, ResourceSet resourceSet) {
        if (filePath != null) {
            URI saveURI = URI.createFileURI((String)filePath);
            Resource resource = resourceSet.createResource(saveURI);
            resource.getContents().add((Object)model);
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                throw new RuntimeException("Saving of resource failed", e);
            }
        }
    }
}

