/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import org.opt4j.viewer.ToolBarOrderComparator;
import org.opt4j.viewer.ToolBarService;

public class ToolBar {
    protected final JToolBar toolBar = new JToolBar();
    protected final Set<ToolBarService> toolBarServices;

    @Inject
    public ToolBar(Set<ToolBarService> toolBarServices) {
        this.toolBarServices = toolBarServices;
    }

    public void init() {
        this.toolBar.setFloatable(false);
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, this.toolBar.getBackground().darker());
        this.toolBar.setBorder(border);
        ArrayList<ToolBarService> list = new ArrayList<ToolBarService>();
        list.addAll(this.toolBarServices);
        Collections.sort(list, new ToolBarOrderComparator());
        for (ToolBarService toolBarService : list) {
            JToolBar component = toolBarService.getToolBar();
            this.toolBar.add(component);
        }
    }

    public JToolBar get() {
        return this.toolBar;
    }
}

