/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.IndividualCollection;
import org.opt4j.core.IndividualCollectionListener;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Population;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.viewer.DelayTask;
import org.opt4j.viewer.QTable;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;

@WidgetParameters(title="Population Monitor", icon="icons/user-blue.png")
public class PopulationWidget
implements IndividualStateListener,
IndividualCollectionListener,
Widget {
    private static final long serialVersionUID = 1L;
    protected static final int OFFSET = 3;
    protected final Archive archive;
    protected final Population population;
    protected final List<Individual> individuals = Collections.synchronizedList(new ArrayList());
    protected final List<Objective> objectives = new ArrayList<Objective>();
    protected JPanel panel = new JPanel();
    protected JTable table;
    protected int size = 0;
    protected boolean isInit = false;
    protected DelayTask task = new DelayTask(40L);

    @Inject
    public PopulationWidget(Population population, Archive archive, IndividualBuilder individualBuilder, Evaluator evaluator) {
        this.archive = archive;
        this.population = population;
        this.objectives.addAll(evaluator.getObjectives());
        Collections.sort(this.objectives);
        int i = 0;
        while (i < 3) {
            try {
                this.individuals.clear();
                this.individuals.addAll(population);
                break;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        population.addListener(this);
        individualBuilder.addIndividualStateListener(this);
    }

    @Override
    public synchronized void init(Viewport viewport) {
        if (!this.isInit) {
            Model model = new Model();
            this.table = new Table(model);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableColumnModel columnModel = PopulationWidget.this.table.getColumnModel();
                    columnModel.getColumn(0).setPreferredWidth(25);
                    columnModel.getColumn(1).setPreferredWidth(140);
                    JScrollPane scrollpane = new JScrollPane(PopulationWidget.this.table);
                    PopulationWidget.this.panel.setLayout(new BorderLayout());
                    PopulationWidget.this.panel.add((Component)scrollpane, "Center");
                    PopulationWidget.this.isInit = true;
                    PopulationWidget.this.paint();
                }
            });
        }
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        this.paint();
    }

    @Override
    public synchronized void individualAdded(IndividualCollection collection, Individual individual) {
        this.individuals.add(individual);
        this.paint();
    }

    @Override
    public synchronized void individualRemoved(IndividualCollection collection, Individual individual) {
        this.individuals.remove(individual);
        this.paint();
    }

    protected void paint() {
        if (this.isInit) {
            this.task.execute(new Runnable(){

                @Override
                public void run() {
                    PopulationWidget.this.table.revalidate();
                    PopulationWidget.this.table.repaint();
                }
            });
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    protected class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected Model() {
        }

        @Override
        public int getColumnCount() {
            return 3 + PopulationWidget.this.objectives.size();
        }

        @Override
        public int getRowCount() {
            PopulationWidget.this.size = Math.max(PopulationWidget.this.size, PopulationWidget.this.individuals.size());
            return PopulationWidget.this.size;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "#";
            }
            if (col == 1) {
                return "Individual";
            }
            if (col == 2) {
                return "State";
            }
            int index = col - 3;
            Objective objective = PopulationWidget.this.objectives.get(index);
            return String.valueOf(objective.getName()) + " (" + (Object)((Object)objective.getSign()) + ")";
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                Individual individual = PopulationWidget.this.individuals.get(row);
                Individual.State state = individual.getState();
                if (individual != null) {
                    if (col == 0) {
                        return row + 1;
                    }
                    if (col == 1) {
                        return individual.getPhenotype();
                    }
                    if (col == 2) {
                        return state;
                    }
                    if (state == Individual.State.EVALUATED) {
                        int index = col - 3;
                        Objectives o = individual.getObjectives();
                        Objective objective = PopulationWidget.this.objectives.get(index);
                        return o.get(objective).getValue();
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {}
            return null;
        }
    }

    protected class Table
    extends QTable {
        private static final long serialVersionUID = 1L;

        public Table(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            String family = c.getFont().getFamily();
            int size = c.getFont().getSize();
            try {
                int model = row;
                Individual individual = PopulationWidget.this.individuals.get(model);
                if (individual != null) {
                    if (PopulationWidget.this.archive.contains(individual)) {
                        c.setFont(new Font(family, 1, size));
                    }
                    if (individual.getState().isProcessing()) {
                        c.setForeground(Color.RED);
                    } else {
                        c.setForeground(Color.BLACK);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return c;
        }
    }
}

