/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Population;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.viewer.ConvergencePlotWidget;
import org.opt4j.viewer.DelayTask;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;
import ptolemy.plot.Plot;

@WidgetParameters(title="Pareto Plot", icon="icons/stat.png")
public class ParetoPlotWidget
implements OptimizerIterationListener,
Widget {
    private static final long serialVersionUID = 1L;
    protected final Population population;
    protected final Archive archive;
    protected final DelayTask task = new DelayTask(40L);
    protected Plot plot;
    protected List<Objective> objectives = new ArrayList<Objective>();
    protected Selection selection;
    protected JPanel panel = new JPanel();
    protected boolean isInit = false;

    @Inject
    public ParetoPlotWidget(Population population, Archive archive, Evaluator evaluator, Optimizer optimizer) {
        this.population = population;
        this.archive = archive;
        optimizer.addOptimizerIterationListener(this);
        Collection<Objective> objectiveCollection = evaluator.getObjectives();
        if (objectiveCollection != null) {
            this.objectives.addAll(objectiveCollection);
        }
        Collections.sort(this.objectives);
    }

    @Override
    public synchronized void init(Viewport viewport) {
        if (!this.isInit) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPanel northPanel = new JPanel(new FlowLayout());
                    ParetoPlotWidget.this.selection = new Selection(ParetoPlotWidget.this.objectives);
                    northPanel.add(ParetoPlotWidget.this.selection);
                    MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, ParetoPlotWidget.this.selection.getBackground().darker());
                    northPanel.setBorder(border);
                    ParetoPlotWidget.this.plot = new Plot();
                    ParetoPlotWidget.this.plot.addLegend(0, "Archive");
                    ParetoPlotWidget.this.plot.addLegend(1, "Population");
                    ParetoPlotWidget.this.plot.setMarksStyle("dots");
                    Color[] colors = new Color[]{Color.RED, Color.LIGHT_GRAY, Color.BLUE};
                    ParetoPlotWidget.this.plot.setColors(colors);
                    ParetoPlotWidget.this.panel.setLayout(new BorderLayout());
                    ParetoPlotWidget.this.panel.add((Component)northPanel, "North");
                    ParetoPlotWidget.this.panel.add((Component)ParetoPlotWidget.this.plot, "Center");
                    ParetoPlotWidget.this.isInit = true;
                    ParetoPlotWidget.this.doPaint();
                }
            });
        }
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        this.doPaint();
    }

    protected Set<Point2D.Double> getPoints(Collection<Individual> indivualCollection, Objective one, Objective two) {
        HashSet<Point2D.Double> points = new HashSet<Point2D.Double>();
        for (Individual individual : indivualCollection) {
            if (individual == null || !individual.isEvaluated()) continue;
            Objectives objectives = individual.getObjectives();
            Value<?> onev = objectives.get(one);
            Value<?> twov = objectives.get(two);
            if (one == null || two == null || onev == null || twov == null || onev.getValue() == Objective.INFEASIBLE || twov.getValue() == Objective.INFEASIBLE) continue;
            double x = objectives.get(one).getDouble();
            double y = objectives.get(two).getDouble();
            Point2D.Double point = new Point2D.Double(x, y);
            points.add(point);
        }
        return points;
    }

    protected void doPaint() {
        if (this.isInit) {
            this.task.execute(new Runnable(){

                @Override
                public void run() {
                    HashSet<Individual> a = new HashSet<Individual>();
                    try {
                        a.addAll(ParetoPlotWidget.this.archive);
                    }
                    catch (Exception exception) {}
                    HashSet<Individual> p = new HashSet<Individual>();
                    try {
                        p.addAll(ParetoPlotWidget.this.population);
                    }
                    catch (Exception exception) {}
                    ParetoPlotWidget.this.paint(a, p);
                }
            });
        }
    }

    protected void paint(Collection<Individual> archive, Collection<Individual> population) {
        if (!this.isInit) {
            return;
        }
        final Objective one = this.selection.getFirst();
        final Objective two = this.selection.getSecond();
        population.removeAll(archive);
        final Set<Point2D.Double> archivePoints = this.getPoints(archive, one, two);
        final Set<Point2D.Double> populationPoints = this.getPoints(population, one, two);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParetoPlotWidget.this.plot.clear(false);
                ParetoPlotWidget.this.plot.setXLabel(one.getName());
                ParetoPlotWidget.this.plot.setYLabel(two.getName());
                for (Point2D.Double point : archivePoints) {
                    ParetoPlotWidget.this.plot.addPoint(0, point.getX(), point.getY(), false);
                }
                for (Point2D.Double point : populationPoints) {
                    ParetoPlotWidget.this.plot.addPoint(1, point.getX(), point.getY(), false);
                }
                ParetoPlotWidget.this.plot.revalidate();
                ParetoPlotWidget.this.plot.repaint();
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    protected class Selection
    extends JToolBar
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected ConvergencePlotWidget.ObjectiveDropDown firstComboBox;
        protected ConvergencePlotWidget.ObjectiveDropDown secondComboBox;

        public Selection(Collection<Objective> objectives) {
            this.firstComboBox = new ConvergencePlotWidget.ObjectiveDropDown(objectives);
            this.secondComboBox = new ConvergencePlotWidget.ObjectiveDropDown(objectives);
            this.firstComboBox.addActionListener(this);
            this.secondComboBox.addActionListener(this);
            this.add(new JLabel("x-Axis: "));
            this.add(this.firstComboBox);
            this.addSeparator();
            this.add(new JLabel("y-Axis: "));
            this.add(this.secondComboBox);
            this.setFloatable(false);
            this.initSelection();
        }

        private void initSelection() {
            if (ParetoPlotWidget.this.objectives.size() <= 0) {
                return;
            }
            Objective objective1 = ParetoPlotWidget.this.objectives.get(0);
            Objective objective2 = ParetoPlotWidget.this.objectives.size() > 1 ? ParetoPlotWidget.this.objectives.get(1) : ParetoPlotWidget.this.objectives.get(0);
            this.firstComboBox.setSelected(objective1);
            this.secondComboBox.setSelected(objective2);
        }

        public Objective getFirst() {
            return this.firstComboBox.getSelected();
        }

        public Objective getSecond() {
            return this.secondComboBox.getSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParetoPlotWidget.this.doPaint();
        }
    }
}

