/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import org.opt4j.core.Objective;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.viewer.ConvergencePlotData;
import org.opt4j.viewer.DelayTask;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;
import ptolemy.plot.Plot;

@WidgetParameters(title="Convergence Plot", icon="icons/convergence.png")
public class ConvergencePlotWidget
implements Widget,
OptimizerIterationListener {
    protected final DelayTask task = new DelayTask(40L);
    protected final ConvergencePlotData data;
    protected final Selection selection;
    protected final JPanel panel;
    protected final Plot plot;

    @Inject
    public ConvergencePlotWidget(Optimizer optimizer, ConvergencePlotData data, Evaluator evaluator) {
        this.data = data;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.plot = new Plot();
        Color[] colors = new Color[]{Color.RED, Color.LIGHT_GRAY, Color.BLUE};
        this.plot.setColors(colors);
        this.panel.add((Component)this.plot);
        Collection<Objective> objectives = evaluator.getObjectives();
        this.selection = objectives != null ? new Selection(objectives) : new Selection(new HashSet<Objective>());
        this.panel.add((Component)this.selection, "North");
        optimizer.addOptimizerIterationListener(this);
        this.doPaint();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void init(Viewport viewport) {
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        this.doPaint();
    }

    protected void doPaint() {
        this.task.execute(new Runnable(){

            @Override
            public void run() {
                ConvergencePlotWidget.this.paint();
            }
        });
    }

    protected void paint() {
        final Objective objective = this.selection.getSelected();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvergencePlotWidget.this.plot.clear(false);
                ConvergencePlotWidget.this.plot.setXLabel("iteration");
                ConvergencePlotWidget.this.plot.setYLabel(objective.getName());
                List<Point2D.Double> list = ConvergencePlotWidget.this.data.getPoints(objective);
                int iteration = ConvergencePlotWidget.this.data.getIteration();
                int i = 0;
                while (i < list.size()) {
                    Point2D.Double p1 = list.get(i);
                    double x = p1.getX();
                    double y = p1.getY();
                    ConvergencePlotWidget.this.plot.addPoint(2, x, y, true);
                    ++i;
                }
                if (!list.isEmpty() && iteration > 0) {
                    Point2D.Double p1 = list.get(list.size() - 1);
                    double x = iteration;
                    double y = p1.getY();
                    ConvergencePlotWidget.this.plot.addPoint(2, x, y, true);
                }
                ConvergencePlotWidget.this.plot.revalidate();
                ConvergencePlotWidget.this.plot.repaint();
            }
        });
    }

    static class ObjectiveDropDown
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public ObjectiveDropDown(Collection<Objective> objectives) {
            super(objectives.toArray());
            this.setRenderer(new ListCellRenderer(){
                protected DefaultListCellRenderer renderer = new DefaultListCellRenderer();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel cell = (JLabel)this.renderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    Objective objective = (Objective)value;
                    cell.setText("objective: " + objective.getName());
                    return cell;
                }
            });
            this.setMaximumSize(this.getPreferredSize());
        }

        public Objective getSelected() {
            return (Objective)this.getSelectedItem();
        }

        public void setSelected(Objective objective) {
            this.setSelectedItem(objective);
        }
    }

    class Selection
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected final ObjectiveDropDown box;

        public Selection(Collection<Objective> objectives) {
            this.box = new ObjectiveDropDown(objectives);
            this.box.addActionListener(this);
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker());
            this.setLayout(new FlowLayout());
            this.add(this.box);
            this.setBorder(border);
        }

        public Objective getSelected() {
            return this.box.getSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConvergencePlotWidget.this.doPaint();
        }
    }
}

