/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.problem.Evaluator;

@Singleton
public class ConvergencePlotData
implements IndividualStateListener,
OptimizerIterationListener {
    protected Map<Objective, PlotDataObjective> map = new HashMap<Objective, PlotDataObjective>();
    protected int iteration = 0;

    @Inject
    public ConvergencePlotData(Evaluator evaluator) {
        Evaluator eval = evaluator;
        for (Objective obj : eval.getObjectives()) {
            this.map.put(obj, new PlotDataObjective(obj));
        }
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        if (individual.isEvaluated()) {
            for (PlotDataObjective data : this.map.values()) {
                data.update(individual.getObjectives());
            }
        }
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        this.iteration = iteration;
        for (PlotDataObjective data : this.map.values()) {
            data.complete(iteration);
        }
    }

    public List<Point2D.Double> getPoints(Objective objective) {
        return this.map.get((Object)objective).values;
    }

    public int getIteration() {
        return this.iteration;
    }

    protected class PlotDataObjective {
        protected final Objective objective;
        protected final List<Point2D.Double> values = new CopyOnWriteArrayList<Point2D.Double>();
        protected double lastValue;
        protected final int MAXVALUES = 130;

        PlotDataObjective(Objective objective) {
            this.objective = objective;
            this.lastValue = objective.getSign() == Objective.Sign.MIN ? Double.MAX_VALUE : Double.MIN_VALUE;
        }

        public void update(Objectives objectives) {
            Value<?> value = objectives.get(this.objective);
            Object v = value.getValue();
            if (v != null && v instanceof Number) {
                Number n = (Number)v;
                double nextValue = n.doubleValue();
                if (this.objective.getSign() == Objective.Sign.MIN && nextValue < this.lastValue) {
                    this.lastValue = nextValue;
                } else if (this.objective.getSign() == Objective.Sign.MAX && nextValue > this.lastValue) {
                    this.lastValue = nextValue;
                }
            }
        }

        protected synchronized void simplify() {
            if (this.values.size() > 130) {
                ArrayList<Point2D.Double> copy = new ArrayList<Point2D.Double>(this.values);
                final HashMap<Point2D.Double, Double> dist = new HashMap<Point2D.Double, Double>();
                int i = 1;
                while (i < copy.size() - 1) {
                    Point2D.Double p0 = (Point2D.Double)copy.get(i - 1);
                    Point2D.Double p1 = (Point2D.Double)copy.get(i);
                    Point2D.Double p2 = (Point2D.Double)copy.get(i + 1);
                    double slope = (p2.y - p0.y) / (p2.x - p0.x);
                    double y = p0.y + slope * (p1.x - p0.x);
                    double v = Math.abs(y - p1.y);
                    dist.put(p1, v);
                    i += 2;
                }
                copy.clear();
                copy.addAll(dist.keySet());
                Collections.sort(copy, new Comparator<Point2D.Double>(){

                    @Override
                    public int compare(Point2D.Double p1, Point2D.Double p2) {
                        Double v1 = (Double)dist.get(p1);
                        Double v2 = (Double)dist.get(p2);
                        return v1.compareTo(v2);
                    }
                });
                this.values.removeAll(copy.subList(0, copy.size() / 2));
            }
        }

        public void complete(int iteration) {
            if (this.lastValue != Double.MIN_VALUE && this.lastValue != Double.MAX_VALUE && (this.values.isEmpty() || this.values.get(this.values.size() - 1).getY() != this.lastValue)) {
                Point2D.Double point = new Point2D.Double(iteration, this.lastValue);
                this.values.add(point);
                if (this.values.size() > 130) {
                    this.simplify();
                }
            }
        }
    }
}

