/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.opt4j.config.Icons;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.ControlListener;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerStateListener;

@Singleton
public class ControlButtons
implements OptimizerStateListener,
ControlListener {
    protected final Control control;
    protected JButton start;
    protected JButton pause;
    protected JButton stop;
    protected JButton terminate;

    @Inject
    public ControlButtons(Control control) {
        this.control = control;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.construct();
    }

    protected final void construct() {
        this.start = new JButton("", Icons.getIcon("icons/control_start.png"));
        this.pause = new JButton("", Icons.getIcon("icons/control_pause.png"));
        this.stop = new JButton("", Icons.getIcon("icons/control_stop.png"));
        this.terminate = new JButton("", Icons.getIcon("icons/control_term.png"));
        this.start.setToolTipText("Start");
        this.pause.setToolTipText("Pause");
        this.stop.setToolTipText("Stop");
        this.terminate.setToolTipText("Terminate");
        this.start.setFocusable(false);
        this.pause.setFocusable(false);
        this.stop.setFocusable(false);
        this.terminate.setFocusable(false);
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlButtons.this.control.doStart();
                ControlButtons.this.update(null);
            }
        });
        this.pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlButtons.this.control.doPause();
                ControlButtons.this.update(null);
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlButtons.this.control.doStop();
                ControlButtons.this.update(null);
            }
        });
        this.terminate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlButtons.this.control.doTerminate();
                ControlButtons.this.update(null);
            }
        });
    }

    protected void update(Optimizer optimizer) {
        Control.State state = optimizer != null && !optimizer.isRunning() ? Control.State.TERMINATED : this.control.getState();
        final boolean bStart = state == Control.State.PAUSED;
        final boolean bPause = state == Control.State.RUNNING;
        final boolean bStop = state == Control.State.RUNNING || state == Control.State.PAUSED;
        final boolean bTerminate = state != Control.State.TERMINATED;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlButtons.this.start.setEnabled(bStart);
                ControlButtons.this.pause.setEnabled(bPause);
                ControlButtons.this.stop.setEnabled(bStop);
                ControlButtons.this.terminate.setEnabled(bTerminate);
            }
        });
    }

    @Override
    public void optimizationStarted(Optimizer optimizer) {
        this.update(optimizer);
    }

    @Override
    public void optimizationStopped(Optimizer optimizer) {
        this.update(optimizer);
    }

    public JButton getStart() {
        return this.start;
    }

    public JButton getPause() {
        return this.pause;
    }

    public JButton getStop() {
        return this.stop;
    }

    public JButton getTerminate() {
        return this.terminate;
    }

    @Override
    public void stateChanged(Control.State state) {
        this.update(null);
    }
}

