/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.tutorial;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.opt4j.core.Individual;
import org.opt4j.tutorial.SalesmanProblem;
import org.opt4j.tutorial.SalesmanRoute;
import org.opt4j.viewer.IndividualMouseListener;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;

public class SalesmanWidgetService
implements IndividualMouseListener {
    protected final Viewport viewport;

    @Inject
    public SalesmanWidgetService(Viewport viewport) {
        this.viewport = viewport;
    }

    @Override
    public void onDoubleClick(Individual individual, Component table, Point p) {
        this.paintRoute(individual);
    }

    @Override
    public void onPopup(final Individual individual, Component table, Point p, JPopupMenu menu) {
        JMenuItem paint = new JMenuItem("show route");
        menu.add(paint);
        paint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesmanWidgetService.this.paintRoute(individual);
            }
        });
    }

    protected void paintRoute(Individual individual) {
        SalesmanWidget widget = new SalesmanWidget(individual);
        this.viewport.addWidget(widget);
    }

    public class MyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected final Individual individual;

        public MyPanel(Individual individual) {
            this.individual = individual;
            this.setPreferredSize(new Dimension(208, 208));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(Color.WHITE);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.clearRect(0, 0, 208, 212);
            SalesmanRoute salesmanRoute = (SalesmanRoute)this.individual.getPhenotype();
            int i = 0;
            while (i < salesmanRoute.size()) {
                int j = (i + 1) % salesmanRoute.size();
                SalesmanProblem.City one = (SalesmanProblem.City)salesmanRoute.get(i);
                SalesmanProblem.City two = (SalesmanProblem.City)salesmanRoute.get(j);
                int x1 = (int)(one.getX() * 2.0) + 4;
                int y1 = (int)(one.getY() * 2.0) + 4;
                int x2 = (int)(two.getX() * 2.0) + 4;
                int y2 = (int)(two.getY() * 2.0) + 4;
                g2d.drawLine(x1, y1, x2, y2);
                g2d.drawOval(x1 - 2, y1 - 2, 4, 4);
                ++i;
            }
        }
    }

    @WidgetParameters(title="Route", resizable=false, maximizable=false)
    protected class SalesmanWidget
    implements Widget {
        final Individual individual;

        public SalesmanWidget(Individual individual) {
            this.individual = individual;
        }

        @Override
        public JPanel getPanel() {
            MyPanel panel = new MyPanel(this.individual);
            return panel;
        }

        @Override
        public void init(Viewport viewport) {
        }
    }
}

