/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.tutorial;

import java.util.Arrays;
import java.util.List;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.tutorial.SalesmanProblem;
import org.opt4j.tutorial.SalesmanRoute;

public class SalesmanEvaluator
implements Evaluator<SalesmanRoute> {
    Objective distance = new Objective("distance", Objective.Sign.MIN);

    @Override
    public Objectives evaluate(SalesmanRoute salesmanRoute) {
        double dist = 0.0;
        int i = 0;
        while (i < salesmanRoute.size()) {
            SalesmanProblem.City one = (SalesmanProblem.City)salesmanRoute.get(i);
            SalesmanProblem.City two = (SalesmanProblem.City)salesmanRoute.get((i + 1) % salesmanRoute.size());
            dist += this.getEuclideanDistance(one, two);
            ++i;
        }
        Objectives objectives = new Objectives();
        objectives.add(this.distance, dist);
        return objectives;
    }

    private double getEuclideanDistance(SalesmanProblem.City one, SalesmanProblem.City two) {
        double x = one.getX() - two.getX();
        double y = one.getY() - two.getY();
        return Math.sqrt(x * x + y * y);
    }

    public List<Objective> getObjectives() {
        return Arrays.asList(this.distance);
    }
}

