/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.tutorial;

import com.google.inject.Inject;
import java.util.Collection;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.copy.Copy;
import org.opt4j.operator.mutate.Mutate;
import org.opt4j.optimizer.ea.Selector;

public class MutateOptimizer
extends AbstractOptimizer {
    protected final Mutate<Genotype> mutate;
    protected final Copy<Genotype> copy;
    protected final Selector selector;
    protected final int iterations;
    public static final int POPSIZE = 100;
    public static final int OFFSIZE = 25;

    @Inject
    public MutateOptimizer(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control, Selector selector, Mutate<Genotype> mutate, Copy<Genotype> copy, @Iterations int iterations) {
        super(population, archive, individualBuilder, completer, control);
        this.mutate = mutate;
        this.copy = copy;
        this.selector = selector;
        this.iterations = iterations;
    }

    @Override
    public void optimize() throws TerminationException, StopException {
        this.selector.init(125);
        int i = 0;
        while (i < 100) {
            this.population.add(this.individualBuilder.build());
            ++i;
        }
        this.nextIteration();
        i = 0;
        while (i < this.iterations) {
            Collection<Individual> parents = this.selector.getParents(25, this.population);
            for (Individual parent : parents) {
                Genotype genotype = this.copy.copy(parent.getGenotype());
                this.mutate.mutate(genotype);
                Individual child = this.individualBuilder.build(genotype);
                this.population.add(child);
            }
            this.completer.complete(this.population);
            Collection<Individual> lames = this.selector.getLames(25, this.population);
            this.population.removeAll(lames);
            this.nextIteration();
            ++i;
        }
    }
}

