/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.tutorial;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.opt4j.common.random.Rand;
import org.opt4j.core.problem.Genotype;
import org.opt4j.sat.AbstractSATDecoder;
import org.opt4j.sat.Constraint;
import org.opt4j.sat.Literal;
import org.opt4j.sat.Model;
import org.opt4j.sat.SATManager;
import org.opt4j.tutorial.MinOnesResult;

public class MinOnesDecoder
extends AbstractSATDecoder<Genotype, MinOnesResult> {
    @Inject
    public MinOnesDecoder(SATManager manager, Rand random) {
        super(manager, random);
    }

    @Override
    public void init(Set<Constraint> constraints) {
        Random random = new Random(0L);
        int i = 0;
        while (i < 1000) {
            Constraint clause = new Constraint(">=", 1);
            HashSet<Integer> vars = new HashSet<Integer>();
            do {
                vars.add(random.nextInt(1000));
            } while (vars.size() < 3);
            Iterator iterator = vars.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                clause.add(new Literal(n, random.nextBoolean()));
            }
            constraints.add(clause);
            ++i;
        }
    }

    @Override
    public MinOnesResult convertModel(Model model) {
        MinOnesResult minOnesResult = new MinOnesResult();
        int i = 0;
        while (i < 1000) {
            if (model.get(i) == null || !model.get(i).booleanValue()) {
                minOnesResult.put(i, false);
            } else {
                minOnesResult.put(i, true);
            }
            ++i;
        }
        return minOnesResult;
    }
}

