/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.start;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Type;
import org.opt4j.config.Task;
import org.opt4j.config.TaskStateListener;
import org.opt4j.core.optimizer.Bootstrap;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.ControlListener;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Genotype;
import org.opt4j.core.problem.Phenotype;
import org.opt4j.operator.Parameters;

public class Opt4JTask
extends Task
implements ControlListener,
OptimizerIterationListener {
    protected Optimizer optimizer = null;
    protected Injector injector = null;
    protected Injector parentInjector = null;
    protected final boolean closeOnStop;
    protected boolean isClosed = false;
    protected boolean initializing = false;

    @Inject
    public Opt4JTask() {
        this(true);
    }

    public Opt4JTask(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
    }

    @Override
    public void execute() throws Exception {
        this.open();
        this.check(this.injector);
        Control control = (Control)this.injector.getInstance(Control.class);
        this.optimizer = (Optimizer)this.injector.getInstance(Optimizer.class);
        this.stateChanged();
        control.addListener(this);
        this.optimizer.addOptimizerIterationListener(this);
        Bootstrap bootstrap = (Bootstrap)this.injector.getInstance(Bootstrap.class);
        bootstrap.execute();
        if (this.closeOnStop) {
            this.close();
        }
    }

    public void init(Injector injector) {
        this.parentInjector = injector;
    }

    public synchronized void close() {
        this.optimizer = null;
        this.injector = null;
        this.isClosed = true;
    }

    public synchronized void open() {
        if (this.injector == null && !this.isClosed) {
            if (!this.isInit) {
                throw new RuntimeException("Task is not initialized. Call method init(modules) first.");
            }
            this.injector = this.parentInjector == null ? Guice.createInjector((Iterable)this.modules) : this.parentInjector.createChildInjector((Iterable)this.modules);
        }
    }

    public int getIteration() {
        Optimizer optimizer = this.getOptimizer();
        if (optimizer == null) {
            return 0;
        }
        return optimizer.getIteration();
    }

    public <O> O getInstance(Class<O> type) {
        Injector injector = this.getInjector();
        if (injector == null) {
            return null;
        }
        return (O)injector.getInstance(type);
    }

    protected Injector getInjector() {
        return this.injector;
    }

    protected Optimizer getOptimizer() {
        return this.optimizer;
    }

    private void check(Injector injector) {
        Creator creator = null;
        Decoder decoder = null;
        Evaluator evaluator = null;
        try {
            creator = (Creator)injector.getInstance(Creator.class);
            decoder = (Decoder)injector.getInstance(Decoder.class);
            evaluator = (Evaluator)injector.getInstance(Evaluator.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem configuration Exception: \n" + e.getLocalizedMessage(), e);
        }
        try {
            injector.getInstance(Optimizer.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Optimizer configuration Exception: \n" + e.getLocalizedMessage(), e);
        }
        try {
            Type creatorType0 = Parameters.getType(Creator.class, creator, "G");
            Type decoderType0 = Parameters.getType(Decoder.class, decoder, "G");
            Type decoderType1 = Parameters.getType(Decoder.class, decoder, "P");
            Type evaluatorType0 = Parameters.getType(Evaluator.class, evaluator, "P");
            Class<Object> creatorGenotype = Parameters.getClass(creatorType0);
            Class<Object> decoderGenotype = Parameters.getClass(decoderType0);
            Class<Object> decoderPhenotype = Parameters.getClass(decoderType1);
            Class<Object> evaluatorPhenotype = Parameters.getClass(evaluatorType0);
            if (creatorGenotype == null) {
                creatorGenotype = Genotype.class;
            }
            if (decoderGenotype == null) {
                decoderGenotype = Genotype.class;
            }
            if (decoderPhenotype == null) {
                decoderPhenotype = Phenotype.class;
            }
            if (evaluatorPhenotype == null) {
                evaluatorPhenotype = Phenotype.class;
            }
            boolean a = decoderGenotype.isAssignableFrom(creatorGenotype);
            boolean b = evaluatorPhenotype.isAssignableFrom(decoderPhenotype);
            if (!a) {
                throw new IllegalArgumentException("Creator(" + creator.getClass() + ") and Decoder(" + decoder.getClass() + ") are not compatible. Creator creates \"" + creatorGenotype + "\", Decoder decodes \"" + decoderGenotype + "\".");
            }
            if (!b) {
                throw new IllegalArgumentException("Decoder(" + decoder.getClass() + ") and Evaluator(" + evaluator.getClass() + ") are not compatible. Decoder decodes \"" + decoderPhenotype + "\", Evaluator evaluates \"" + evaluatorPhenotype + "\".");
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    @Override
    public void stateChanged(Control.State state) {
        this.stateChanged();
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        this.stateChanged();
    }

    private void stateChanged() {
        for (TaskStateListener listener : this.listeners) {
            listener.stateChanged(this);
        }
    }
}

