/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat.sat4j;

import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.Heap;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.UserFixedPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;

public class VariableOrder
extends VarOrderHeap {
    protected static final double VAR_RESCALE_FACTOR = 1.0E-100;
    protected static final double VAR_RESCALE_BOUND = 1.0E100;
    private static final long serialVersionUID = 1L;
    protected double varInc = 0.0;
    protected boolean[] phase;

    public VariableOrder() {
        super((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    public void setLits(ILits lits) {
        this.lits = lits;
        int nlength = lits.nVars() + 1;
        this.activity = new double[nlength];
        this.phase = new boolean[nlength];
        this.activity[0] = -1.0;
        this.heap = new Heap(this.activity);
        this.heap.setBounds(nlength);
        int i = 1;
        while (i < nlength) {
            assert (i > 0);
            assert (i <= lits.nVars()) : String.valueOf(lits.nVars()) + "/" + i;
            this.activity[i] = 0.0;
            if (lits.belongsToPool(i)) {
                this.heap.insert(i);
                this.phase[i] = false;
            } else {
                this.phase[i] = false;
            }
            ++i;
        }
    }

    public void init() {
    }

    protected void updateActivity(int var) {
        int n = var;
        double d = this.activity[n] = this.activity[n] + this.varInc;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
    }

    protected void updateActivity(int var, double value) {
        int n = var;
        double d = this.activity[n] = this.activity[n] + value;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
    }

    public void updateVar(int p) {
        int var = p >> 1;
        this.updateActivity(var);
        if (this.heap.inHeap(var)) {
            this.heap.increase(var);
        }
    }

    public void setVarInc(double value) {
        this.varInc = value;
    }

    protected void varRescaleActivity() {
        int i = 1;
        while (i < this.activity.length) {
            int n = i++;
            this.activity[n] = this.activity[n] * 1.0E-100;
        }
        this.varInc *= 1.0E-100;
    }

    public void setVarActivity(int var, double value) {
        this.updateActivity(var, value);
        if (this.heap.inHeap(var)) {
            this.heap.increase(var);
        }
    }

    public void setVarPhase(int var, boolean p) {
        this.phase[var] = p;
    }

    public int select() {
        while (!this.heap.empty()) {
            int var = this.heap.getmin();
            int next = this.phase[var] ? LiteralsUtils.posLit((int)var) : LiteralsUtils.negLit((int)var);
            if (!this.lits.isUnassigned(next)) continue;
            return next;
        }
        return -1;
    }
}

