/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat.sat4j;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.opt4j.sat.Constraint;
import org.opt4j.sat.Instance;
import org.opt4j.sat.Solver;
import org.opt4j.sat.sat4j.SAT4JInstance;
import org.opt4j.start.Constant;

public class SAT4JSolver
implements Solver {
    private static final long serialVersionUID = 1L;
    protected int timeout;
    protected int clauseLearningLength;
    protected Restarts restarts;
    protected Learning learning;
    Instance instance;

    public SAT4JSolver(int timeout, int clauseLearningLength) {
        this(timeout, clauseLearningLength, Learning.FIXEDLENGTH, Restarts.MINISAT);
    }

    @Inject
    public SAT4JSolver(@Constant(value="timeout", namespace=SAT4JSolver.class) int timeout, @Constant(value="clauseLearningLength", namespace=SAT4JSolver.class) int clauseLearningLength, @Constant(value="learning", namespace=SAT4JSolver.class) Learning learning, @Constant(value="restarts", namespace=SAT4JSolver.class) Restarts restarts) {
        this.timeout = timeout;
        this.clauseLearningLength = clauseLearningLength;
        this.learning = learning;
        this.restarts = restarts;
        this.instance = this.createInstance();
    }

    @Override
    public void addConstraint(Constraint constraint) {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
        this.instance.addConstraint(constraint);
    }

    @Override
    public Instance getInstance() {
        if (this.instance == null) {
            return this.createInstance();
        }
        Instance i = this.instance;
        this.instance = null;
        return i;
    }

    @Override
    public void returnInstance(Instance instance) {
        this.instance = instance;
    }

    private Instance createInstance() {
        return new SAT4JInstance(this.timeout, this.clauseLearningLength, this.learning, this.restarts);
    }

    @Override
    public void addVars(int newVars) {
        this.instance.addVars(newVars);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    protected static @interface ClauseLearningLength {
    }

    public static enum Learning {
        FIXEDLENGTH,
        MINISAT,
        CLAUSEONLY;

    }

    public static enum Restarts {
        MINISAT,
        LUBY,
        RAPID;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    protected static @interface Timeout {
    }
}

