/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat.sat4j;

import java.lang.constant.Constable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opt4j.sat.Constraint;
import org.opt4j.sat.ContradictionException;
import org.opt4j.sat.Instance;
import org.opt4j.sat.Literal;
import org.opt4j.sat.Model;
import org.opt4j.sat.Order;
import org.opt4j.sat.TimeoutException;
import org.opt4j.sat.VarOrder;
import org.opt4j.sat.sat4j.SAT4JSolver;
import org.opt4j.sat.sat4j.VariableOrder;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.ClauseOnlyLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.ArminRestarts;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.pb.constraints.CompetResolutionPBMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class SAT4JInstance
implements Instance {
    protected int maxVar = -1;
    protected PBSolverResolution solver;
    protected Order order;
    protected Model model;
    protected Map<Object, Integer> variables = new HashMap<Object, Integer>();
    protected int nextVariable = 1;
    protected int nVars = 0;
    protected boolean okay = true;

    public SAT4JInstance(int timeout, int clauseLearningLength, SAT4JSolver.Learning learning, SAT4JSolver.Restarts restarts) {
        MiniSATLearning l = null;
        switch (learning) {
            case FIXEDLENGTH: {
                l = new FixedLengthLearning(clauseLearningLength);
                break;
            }
            case MINISAT: {
                l = new MiniSATLearning();
                break;
            }
            case CLAUSEONLY: {
                l = new ClauseOnlyLearning();
            }
        }
        MiniSATRestarts r = null;
        switch (restarts) {
            case MINISAT: {
                r = new MiniSATRestarts();
                break;
            }
            case LUBY: {
                r = new LubyRestarts();
                break;
            }
            case RAPID: {
                r = new ArminRestarts();
            }
        }
        this.solver = new PBSolverResolution((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy)l, (PBDataStructureFactory)new CompetResolutionPBMixedHTClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap((IPhaseSelectionStrategy)new PositiveLiteralSelectionStrategy()), (RestartStrategy)r);
        l.setSolver((Solver)this.solver);
        l.setVarActivityListener((VarActivityListener)this.solver);
        if (l instanceof MiniSATLearning) {
            l.setDataStructureFactory(this.solver.getDSFactory());
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.solver.setTimeout(timeout);
        this.setNVars(100);
    }

    @Override
    public void addVars(int newVars) {
        if (newVars > 0) {
            this.setNVars(this.nVars + newVars);
        }
    }

    protected void setNVars(int n) {
        this.solver.newVar(n);
        this.nVars = n;
    }

    @Override
    public void addConstraint(Constraint constraint) {
        VecInt lits = this.toVecInt(constraint.getLiterals());
        Vec coeffs = new Vec();
        for (Integer value : constraint.getCoefficients()) {
            coeffs.push((Object)new BigInteger(value.toString()));
        }
        Constraint.Operator operator = constraint.getOperator();
        int value = constraint.getRhs();
        BigInteger d = BigInteger.valueOf(value);
        try {
            if (operator == Constraint.Operator.LE || operator == Constraint.Operator.EQ) {
                this.solver.addPseudoBoolean((IVecInt)lits, (IVec)coeffs, false, d);
            }
            if (operator == Constraint.Operator.GE || operator == Constraint.Operator.EQ) {
                this.solver.addPseudoBoolean((IVecInt)lits, (IVec)coeffs, true, d);
            }
        }
        catch (org.sat4j.specs.ContradictionException contradictionException) {
            this.okay = false;
            throw new ContradictionException();
        }
    }

    protected VecInt toVecInt(Iterable<Literal> list) {
        VecInt vector = new VecInt();
        for (Literal literal : list) {
            Object var = literal.variable();
            if (!this.variables.containsKey(var)) {
                this.variables.put(var, this.nextVariable++);
                if (this.variables.size() > this.nVars) {
                    this.setNVars(this.nVars * 2);
                }
            }
            boolean phase = literal.phase();
            vector.push(this.variables.get(var) * (phase ? 1 : -1));
        }
        return vector;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public boolean solve() throws TimeoutException {
        if (!this.okay) {
            return false;
        }
        return this.solve(new ArrayList<Literal>());
    }

    @Override
    public boolean solve(List<Literal> assumptions) throws TimeoutException {
        int var;
        if (this.order instanceof VarOrder) {
            VarOrder varOrder = (VarOrder)this.order;
            VariableOrder o = new VariableOrder();
            this.solver.setOrder((IOrder)o);
            for (Map.Entry<Object, Double> entry : varOrder.getActivityEntrySet()) {
                if (!this.variables.containsKey(entry.getKey())) continue;
                var = this.variables.get(entry.getKey());
                o.setVarActivity(var, entry.getValue());
            }
            for (Map.Entry<Object, Constable> entry : varOrder.getPhaseEntrySet()) {
                if (!this.variables.containsKey(entry.getKey())) continue;
                var = this.variables.get(entry.getKey());
                o.setVarPhase(var, (Boolean)entry.getValue());
            }
            o.setVarInc(varOrder.getVarInc());
            o.setVarDecay(varOrder.getVarDecay());
        }
        try {
            VecInt assumps = this.toVecInt(assumptions);
            this.okay = assumps.isEmpty() ? this.okay && this.solver.isSatisfiable() : this.solver.isSatisfiable((IVecInt)assumps);
            if (this.okay) {
                this.model = new Model();
                for (Map.Entry<Object, Integer> entry : this.variables.entrySet()) {
                    Object identifier = entry.getKey();
                    var = entry.getValue();
                    this.model.set(identifier, this.solver.model(var));
                }
                return true;
            }
        }
        catch (org.sat4j.specs.TimeoutException timeoutException) {
            throw new TimeoutException();
        }
        return false;
    }

    @Override
    public Model getModel() {
        return this.model;
    }
}

