/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat;

import com.google.inject.internal.Preconditions;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.sat.MixedSATManager;
import org.opt4j.sat.SATManager;
import org.opt4j.start.Constant;
import org.opt4j.start.Opt4JModule;

@Icon(value="icons/puzzle-green.png")
@Info(value="Module for the configuration of SAT decoding.")
public class SATDecoderModule
extends Opt4JModule {
    @Info(value="The number of instances (pooled).")
    @Constant(value="instances", namespace=MixedSATManager.class)
    protected int instances = 2;

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        Preconditions.checkState((instances > 0 ? 1 : 0) != 0, (String)"The number of instances must be positive: %s", (Object[])new Object[]{instances});
        this.instances = instances;
    }

    @Override
    public void config() {
        this.bind(SATManager.class).to(MixedSATManager.class).in(SINGLETON);
    }
}

