/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat;

import java.util.ArrayList;
import java.util.List;
import org.opt4j.sat.Constraint;
import org.opt4j.sat.Instance;
import org.opt4j.sat.Solver;

public class PooledSolver
implements Solver {
    protected List<Constraint> constraints = new ArrayList<Constraint>();
    protected int nVars = 0;
    protected int nInstances = 0;
    protected List<Instance> instances = new ArrayList<Instance>();
    protected Pool pool = new Pool();
    protected Solver solver;

    public PooledSolver(Solver solver) {
        this(solver, 1);
    }

    public PooledSolver(Solver solver, int size) {
        this.solver = solver;
        if (size < 1) {
            throw new IllegalArgumentException("Invalid pool size: " + size);
        }
        this.setPoolSize(size);
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        for (Instance instance : this.instances) {
            instance.addConstraint(constraint);
        }
    }

    @Override
    public Instance getInstance() {
        return this.pool.get();
    }

    @Override
    public void returnInstance(Instance instance) {
        this.pool.add(instance);
    }

    public void setPoolSize(int n) {
        block4: {
            block3: {
                if (n <= this.nInstances) break block3;
                while (n > this.nInstances) {
                    ++this.nInstances;
                    Instance instance = this.solver.getInstance();
                    instance.addVars(this.nVars);
                    for (Constraint constraint : this.constraints) {
                        instance.addConstraint(constraint);
                    }
                    this.instances.add(instance);
                    this.pool.add(instance);
                }
                break block4;
            }
            if (n >= this.nInstances) break block4;
            while (n < this.nInstances) {
                --this.nInstances;
                Instance instance = this.instances.remove(0);
                this.pool.remove(instance);
            }
        }
    }

    @Override
    public void addVars(int newVars) {
        this.nVars += newVars;
        for (Instance instance : this.instances) {
            instance.addVars(newVars);
        }
    }

    protected static class Pool {
        protected List<Instance> list = new ArrayList<Instance>();

        protected Pool() {
        }

        public synchronized Instance get() {
            while (this.list.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.list.remove(0);
        }

        public synchronized void remove(Instance instance) {
            this.list.remove(instance);
        }

        public synchronized void add(Instance instance) {
            this.list.add(instance);
            this.notifyAll();
        }
    }
}

