/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.opt4j.core.problem.Genotype;
import org.opt4j.genotype.BooleanGenotype;
import org.opt4j.genotype.BooleanMapGenotype;
import org.opt4j.genotype.DoubleBounds;
import org.opt4j.genotype.DoubleGenotype;
import org.opt4j.genotype.DoubleMapGenotype;
import org.opt4j.sat.Instance;
import org.opt4j.sat.Model;
import org.opt4j.sat.PooledSolver;
import org.opt4j.sat.SATGenotype;
import org.opt4j.sat.SATManager;
import org.opt4j.sat.Solver;
import org.opt4j.sat.TimeoutException;
import org.opt4j.sat.VarOrder;
import org.opt4j.start.Constant;

public class MixedSATManager
implements SATManager {
    protected final Solver solver;

    @Inject
    public MixedSATManager(Solver solver, @Constant(value="instances", namespace=MixedSATManager.class) int instances) {
        PooledSolver pool = new PooledSolver(solver, instances);
        this.solver = pool;
    }

    @Override
    public Genotype createSATGenotype(List<Object> variables, Map<Object, Double> lowerBounds, Map<Object, Double> upperBounds, Map<Object, Double> priorities, Map<Object, Boolean> phases) {
        int size = variables.size();
        double[] lower = new double[size];
        double[] upper = new double[size];
        int i = 0;
        while (i < size) {
            Object variable = variables.get(i);
            Double lb = lowerBounds.get(variable);
            Double ub = upperBounds.get(variable);
            if (lb == null) {
                lb = 0.0;
            }
            if (ub == null) {
                ub = 1.0;
            }
            lower[i] = lb;
            upper[i] = ub;
            ++i;
        }
        DoubleBounds doubleBounds = new DoubleBounds(lower, upper);
        DoubleMapGenotype<Object> doubleVector = new DoubleMapGenotype<Object>(variables, doubleBounds);
        BooleanMapGenotype<Object> booleanVector = new BooleanMapGenotype<Object>(variables);
        SATGenotype satGenotype = new SATGenotype(booleanVector, doubleVector);
        for (Object variable : variables) {
            double priority = priorities.get(variable);
            boolean phase = phases.get(variable);
            doubleVector.add(priority);
            booleanVector.add(phase);
        }
        return satGenotype;
    }

    @Override
    public Model decodeSATGenotype(List<Object> variables, Genotype genotype) {
        SATGenotype satGenotype = (SATGenotype)genotype;
        BooleanGenotype booleanVector = satGenotype.getBooleanVector();
        DoubleGenotype doubleVector = satGenotype.getDoubleVector();
        VarOrder varorder = new VarOrder();
        int i = 0;
        while (i < variables.size()) {
            Object var = variables.get(i);
            varorder.setActivity(var, (Double)doubleVector.get(i));
            varorder.setPhase(var, (Boolean)booleanVector.get(i));
            ++i;
        }
        Instance instance = this.solver.getInstance();
        varorder.setVarInc(1.0 / (2.0 * (double)variables.size()));
        varorder.setVarDecay(1.0526315789473684);
        instance.setOrder(varorder);
        try {
            if (instance.solve()) {
                Model model = instance.getModel();
                return model;
            }
        }
        catch (TimeoutException timeoutException) {
            System.err.println("timeout");
            return null;
        }
        finally {
            this.solver.returnInstance(instance);
        }
        return null;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }
}

