/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opt4j.sat.Literal;
import org.opt4j.sat.Model;
import org.opt4j.sat.Term;

public class Constraint
extends ArrayList<Term> {
    protected List<Term> terms = new ArrayList<Term>();
    protected Operator operator = Operator.GE;
    protected int rhs = 1;
    private static final long serialVersionUID = 1L;

    public Constraint() {
        this(Operator.GE, 1);
    }

    public Constraint(String operator, int rhs) {
        this(Operator.getOperator(operator), rhs);
    }

    public Constraint(Operator operator, int rhs) {
        this.operator = operator;
        this.rhs = rhs;
    }

    public Iterable<Integer> getCoefficients() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < Constraint.this.size();
                    }

                    @Override
                    public Integer next() {
                        return ((Term)Constraint.this.get(this.i++)).getCoefficient();
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("Operation not supported");
                    }
                };
            }
        };
    }

    public Iterable<Literal> getLiterals() {
        return new Iterable<Literal>(){

            @Override
            public Iterator<Literal> iterator() {
                return new Iterator<Literal>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < Constraint.this.size();
                    }

                    @Override
                    public Literal next() {
                        return ((Term)Constraint.this.get(this.i++)).getLiteral();
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("Operation not supported");
                    }
                };
            }
        };
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public int getRhs() {
        return this.rhs;
    }

    public void setRhs(int rhs) {
        this.rhs = rhs;
    }

    @Override
    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.size()) {
            s = String.valueOf(s) + this.get(i);
            if (i < this.size() - 1) {
                s = String.valueOf(s) + " + ";
            }
            ++i;
        }
        s = String.valueOf(s) + " " + (Object)((Object)this.operator) + " ";
        s = String.valueOf(s) + this.rhs;
        return s;
    }

    public boolean isSatisfied(Model model) {
        int count = this.getCount(model);
        return this.operator.isTrue(count, this.rhs);
    }

    public int getViolationCount(Model model) {
        int count = this.getCount(model);
        switch (this.operator) {
            case LE: {
                return count <= this.rhs ? 0 : count - this.rhs;
            }
            case EQ: {
                return Math.abs(count - this.rhs);
            }
        }
        return count >= this.rhs ? 0 : this.rhs - count;
    }

    public void add(Literal lit) {
        this.add(1, lit);
    }

    @Override
    public void add(int coeff, Literal lit) {
        Term term = new Term(coeff, lit);
        this.add(term);
    }

    private int getCount(Model model) {
        int count = 0;
        for (Term term : this) {
            Literal literal = term.getLiteral();
            int coefficient = term.getCoefficient();
            Object var = literal.variable();
            Boolean phase = literal.phase();
            if (!phase.equals(model.get(var))) continue;
            count += coefficient;
        }
        return count;
    }

    public Constraint copy() {
        Constraint pb = new Constraint(this.operator, this.rhs);
        for (Term term : this) {
            pb.add(term.copy());
        }
        return pb;
    }

    public boolean contains(Literal literal) {
        for (Term term : this) {
            if (!literal.equals(term.getLiteral())) continue;
            return true;
        }
        return false;
    }

    public static enum Operator {
        LE,
        EQ,
        GE;


        public String toString() {
            switch (this) {
                case LE: {
                    return "<=";
                }
                case EQ: {
                    return "=";
                }
            }
            return ">=";
        }

        public boolean isTrue(int lhs, int rhs) {
            switch (this) {
                case LE: {
                    return lhs <= rhs;
                }
                case EQ: {
                    return lhs == rhs;
                }
            }
            return lhs >= rhs;
        }

        public static Operator getOperator(String string) {
            if ("<=".equals(string)) {
                return LE;
            }
            if ("=".equals(string)) {
                return EQ;
            }
            if (">=".equals(string)) {
                return GE;
            }
            throw new IllegalArgumentException("Unknown operator " + string + ". Allowed operators are: <=,=,>=");
        }
    }
}

