/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.sat;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.opt4j.common.random.Rand;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Genotype;
import org.opt4j.core.problem.Phenotype;
import org.opt4j.sat.Constraint;
import org.opt4j.sat.Literal;
import org.opt4j.sat.Model;
import org.opt4j.sat.SATManager;
import org.opt4j.sat.Solver;

public abstract class AbstractSATDecoder<G extends Genotype, P extends Phenotype>
implements Decoder<G, P>,
Creator<G> {
    protected List<Constraint> constraints = new ArrayList<Constraint>();
    protected List<Object> variables = new ArrayList<Object>();
    protected Map<Object, Double> lowerBounds;
    protected Map<Object, Double> upperBounds;
    protected final Random random;
    protected final SATManager manager;
    protected boolean isInit = false;

    @Inject
    public AbstractSATDecoder(SATManager manager, Rand random) {
        this.random = random;
        this.manager = manager;
    }

    protected synchronized void init() {
        if (!this.isInit) {
            try {
                try {
                    Solver solver = this.manager.getSolver();
                    HashSet<Constraint> constraints = new HashSet<Constraint>();
                    this.init(constraints);
                    HashSet<Object> variables = new HashSet<Object>();
                    for (Constraint constraint : constraints) {
                        solver.addConstraint(constraint);
                        this.constraints.add(constraint);
                        for (Literal literal : constraint.getLiterals()) {
                            variables.add(literal.variable());
                        }
                    }
                    Set<Object> ignores = this.ignoreVariables(variables);
                    variables.removeAll(ignores);
                    this.variables.addAll(variables);
                    this.lowerBounds = this.getLowerBounds(variables);
                    this.upperBounds = this.getUpperBounds(variables);
                }
                catch (Throwable e) {
                    System.err.println("Failed initialization of " + this.getClass().getName() + " with " + e);
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.isInit = true;
            }
        }
    }

    public abstract void init(Set<Constraint> var1);

    public void randomize(Collection<Object> variables, Map<Object, Double> lowerBounds, Map<Object, Double> upperBounds, Map<Object, Double> priorities, Map<Object, Boolean> phases) {
        for (Object variable : variables) {
            Double lb = lowerBounds.get(variable);
            Double ub = upperBounds.get(variable);
            if (lb == null) {
                lb = 0.0;
            }
            if (ub == null) {
                ub = 1.0;
            }
            double priority = lb + (ub - lb) * this.random.nextDouble();
            priorities.put(variable, priority);
            phases.put(variable, this.random.nextBoolean());
        }
    }

    public Set<Object> ignoreVariables(Set<Object> variables) {
        return new HashSet<Object>();
    }

    public Map<Object, Double> getLowerBounds(Set<Object> variables) {
        return new HashMap<Object, Double>();
    }

    public Map<Object, Double> getUpperBounds(Set<Object> variables) {
        return new HashMap<Object, Double>();
    }

    public abstract P convertModel(Model var1);

    @Override
    public G create() {
        return (G)this.createSATGenotype();
    }

    protected Genotype createSATGenotype() {
        if (!this.isInit) {
            this.init();
        }
        HashMap<Object, Double> priorities = new HashMap<Object, Double>();
        HashMap<Object, Boolean> phases = new HashMap<Object, Boolean>();
        this.randomize(this.variables, this.lowerBounds, this.upperBounds, priorities, phases);
        return this.manager.createSATGenotype(this.variables, this.lowerBounds, this.upperBounds, priorities, phases);
    }

    @Override
    public P decode(G genotype) {
        Model model = this.decodeSATGenotype((Genotype)genotype);
        return this.convertModel(model);
    }

    protected Model decodeSATGenotype(Genotype genotype) {
        if (!this.isInit) {
            this.init();
        }
        return this.manager.decodeSATGenotype(this.variables, genotype);
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Object> getVariables() {
        return this.variables;
    }
}

