/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.sa;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Objectives;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.copy.Copy;
import org.opt4j.operator.neighbor.Neighbor;
import org.opt4j.optimizer.sa.CoolingSchedule;

public class SimulatedAnnealing
extends AbstractOptimizer {
    protected final Random random;
    protected final Neighbor<Genotype> neighbor;
    protected final Copy<Genotype> copy;
    protected final int iterations;
    protected final CoolingSchedule coolingSchedule;

    @Inject
    public SimulatedAnnealing(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control, Rand random, Neighbor<Genotype> neighbor, Copy<Genotype> copy, @Iterations int iterations, CoolingSchedule coolingSchedule) {
        super(population, archive, individualBuilder, completer, control);
        this.random = random;
        this.neighbor = neighbor;
        this.copy = copy;
        this.iterations = iterations;
        this.coolingSchedule = coolingSchedule;
    }

    @Override
    public void optimize() throws TerminationException, StopException {
        Individual x = this.individualBuilder.build();
        Individual y = null;
        this.population.add(x);
        this.completer.complete(this.population);
        this.archive.update(x);
        this.nextIteration();
        double fx = this.f(x);
        int i = 0;
        while (i < this.iterations) {
            Genotype g = this.copy.copy(x.getGenotype());
            this.neighbor.neighbor(g);
            y = this.individualBuilder.build(g);
            this.completer.complete(y);
            this.archive.update(y);
            double fy = this.f(y);
            boolean sw = false;
            if (fy <= fx) {
                sw = true;
            } else {
                double a = (fx - fy) / this.coolingSchedule.getTemperature(i, this.iterations);
                double e = Math.exp(a);
                if (this.random.nextDouble() < e) {
                    sw = true;
                }
            }
            if (sw) {
                this.population.remove(x);
                this.population.add(y);
                fx = fy;
                x = y;
            }
            this.nextIteration();
            ++i;
        }
    }

    protected double f(Individual individual) {
        Objectives objectives = individual.getObjectives();
        double sum = 0.0;
        double[] dArray = objectives.array();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum;
    }
}

