/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.rs;

import org.opt4j.config.annotations.Info;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.OptimizerModule;
import org.opt4j.optimizer.rs.RandomSearch;
import org.opt4j.start.Constant;

@Info(value="A simple random search.")
public class RandomSearchModule
extends OptimizerModule {
    @Info(value="A number of evaluations.")
    @Constant(value="evaluations", namespace=RandomSearch.class)
    protected int evaluations = 25000;
    @Info(value="A number of batched evaluations.")
    @Constant(value="batchsize", namespace=RandomSearch.class)
    protected int batchsize = 25;

    public int getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(int evaluations) {
        this.evaluations = evaluations;
    }

    public int getBatchsize() {
        return this.batchsize;
    }

    public void setBatchsize(int batchsize) {
        this.batchsize = batchsize;
    }

    @Override
    protected void config() {
        this.bindOptimizer(RandomSearch.class);
        this.bindConstant(Iterations.class).to(this.evaluations / this.batchsize);
    }
}

