/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.rs;

import com.google.inject.Inject;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.start.Constant;

public class RandomSearch
extends AbstractOptimizer {
    protected final int evaluations;
    protected final int batchsize;

    @Inject
    public RandomSearch(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control, @Constant(value="evaluations", namespace=RandomSearch.class) int evaluations, @Constant(value="batchsize", namespace=RandomSearch.class) int batchsize) {
        super(population, archive, individualBuilder, completer, control);
        this.evaluations = evaluations;
        this.batchsize = batchsize;
    }

    @Override
    public void optimize() throws StopException, TerminationException {
        int i = 0;
        while (i < this.evaluations) {
            Individual individual = this.individualBuilder.build();
            this.population.add(individual);
            if ((i + 1) % this.batchsize == 0) {
                this.nextIteration();
                this.population.clear();
            }
            ++i;
        }
        if (this.population.size() > 0) {
            this.nextIteration();
            this.population.clear();
        }
    }
}

