/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.mopso;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.operator.mutate.MutateDoubleElementwise;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.mopso.MutateDoubleNonUniform;
import org.opt4j.start.Constant;

public class MutateDoubleUniform
extends MutateDoubleElementwise {
    protected final double perturbation;

    @Inject
    public MutateDoubleUniform(MutationRate mutationRate, Rand random, NormalizeDouble normalize, @Constant(value="perturbation", namespace=MutateDoubleNonUniform.class) double perturbation) {
        super(mutationRate, random, normalize);
        this.perturbation = perturbation;
    }

    @Override
    protected double mutateElement(double x) {
        if (this.random.nextDouble() < this.mutationRate.get()) {
            double v = (this.random.nextDouble() - 0.5) * this.perturbation;
            x += v;
        }
        return x;
    }
}

