/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.mopso;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.mopso.MutateDoubleUniform;
import org.opt4j.start.Constant;

public class MutateDoubleNonUniform
extends MutateDoubleUniform {
    protected final Optimizer optimizer;
    protected final int maxIterations;

    @Inject
    public MutateDoubleNonUniform(MutationRate mutationRate, Rand random, NormalizeDouble normalize, Optimizer optimizer, @Constant(value="perturbation", namespace=MutateDoubleNonUniform.class) double perturbation, @Iterations int maxIterations) {
        super(mutationRate, random, normalize, perturbation);
        this.optimizer = optimizer;
        this.maxIterations = maxIterations;
    }

    @Override
    protected double mutateElement(double x) {
        if (this.random.nextDouble() < this.mutationRate.get()) {
            double tau = this.random.nextBoolean() ? 1 : -1;
            x += tau * this.delta(this.perturbation);
        }
        return x;
    }

    protected double delta(double perturbation) {
        double r = this.random.nextDouble();
        double actIter = this.optimizer.getIteration();
        double maxIter = this.maxIterations;
        double ratio = actIter / maxIter;
        ratio = Math.min(ratio, 1.0);
        double y = Math.pow(1.0 - ratio, perturbation);
        return 1.0 * (1.0 - Math.pow(r, y));
    }
}

