/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.mopso;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.opt4j.common.archive.CrowdingArchive;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Archive;
import org.opt4j.core.IncompatibilityException;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Objectives;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Genotype;
import org.opt4j.genotype.DoubleGenotype;
import org.opt4j.operator.algebra.Add;
import org.opt4j.operator.algebra.AlgebraDouble;
import org.opt4j.operator.algebra.Index;
import org.opt4j.operator.algebra.Term;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.mopso.Crowding;
import org.opt4j.optimizer.mopso.MutateDoubleNonUniform;
import org.opt4j.optimizer.mopso.MutateDoubleUniform;
import org.opt4j.optimizer.mopso.Particle;
import org.opt4j.optimizer.mopso.ParticleBuilder;
import org.opt4j.optimizer.mopso.VelocityTerm;
import org.opt4j.start.Constant;

public class MOPSO
extends AbstractOptimizer {
    protected final int iterations;
    protected final int size;
    protected final Archive leaders;
    protected final ParticleBuilder particleBuilder;
    protected final AlgebraDouble algebra;
    protected final Random random;
    protected final VelocityTerm velocityTerm;
    protected final Term positionTerm;
    protected final MutateDoubleUniform uniform;
    protected final MutateDoubleUniform nonUniform;

    @Inject
    public MOPSO(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control, Rand random, MutateDoubleUniform uniform, MutateDoubleNonUniform nonUniform, @Iterations int iterations, @Constant(value="size", namespace=MOPSO.class) int size, @Constant(value="archiveSize", namespace=MOPSO.class) int archiveSize) {
        super(population, archive, individualBuilder, completer, control);
        this.particleBuilder = (ParticleBuilder)individualBuilder;
        this.leaders = new CrowdingArchive(archiveSize);
        this.random = random;
        this.uniform = uniform;
        this.nonUniform = nonUniform;
        this.size = size;
        this.iterations = iterations;
        this.algebra = new AlgebraDouble(new NormalizeDouble(){

            @Override
            public void normalize(DoubleGenotype genotype) {
            }
        });
        Index x = new Index(0);
        Index v = new Index(1);
        this.positionTerm = new Add(x, v);
        this.velocityTerm = new VelocityTerm(random);
    }

    @Override
    public void optimize() throws StopException, TerminationException {
        this.initPopulation();
        this.nextIteration();
        int i = 0;
        while (i < this.iterations) {
            this.updateLeaders(this.leaders, this.population);
            Map<Particle, Particle> lead = this.getLeaders(this.leaders, this.population);
            Map<Particle, Particle> next = this.move(this.population, lead);
            this.population.addAll((Collection<? extends Individual>)next.values());
            this.completer.complete(this.population);
            this.updatePersonalBest(next);
            this.population.removeAll(next.keySet());
            this.nextIteration();
            ++i;
        }
    }

    protected Map<Particle, Particle> move(Population population, Map<Particle, Particle> leaders) {
        HashMap<Particle, Particle> map = new HashMap<Particle, Particle>();
        for (Individual individual : population) {
            Particle particle = (Particle)individual;
            DoubleGenotype position = (DoubleGenotype)particle.getGenotype();
            DoubleGenotype velocity = (DoubleGenotype)particle.getVelocity();
            DoubleGenotype best = (DoubleGenotype)particle.getBest();
            int id = particle.getId();
            DoubleGenotype leader = (DoubleGenotype)leaders.get(particle).getGenotype();
            this.velocityTerm.randomize();
            DoubleGenotype nextVelocity = this.algebra.algebra(this.velocityTerm, position, velocity, best, leader);
            DoubleGenotype nextPosition = this.algebra.algebra(this.positionTerm, position, nextVelocity);
            int k = 0;
            while (k < nextPosition.size()) {
                double value = (Double)nextPosition.get(k);
                double lb = nextPosition.getLowerBound(k);
                double ub = nextPosition.getUpperBound(k);
                if (value < lb) {
                    nextPosition.set(k, lb);
                    nextVelocity.set(k, -((Double)nextVelocity.get(k)).doubleValue());
                } else if (value > ub) {
                    nextPosition.set(k, ub);
                    nextVelocity.set(k, -((Double)nextVelocity.get(k)).doubleValue());
                }
                ++k;
            }
            if (id % 3 == 0) {
                this.uniform.mutate(nextPosition);
            } else if (id % 3 == 1) {
                this.nonUniform.mutate(nextPosition);
            }
            Particle p = this.particleBuilder.build(id, nextPosition, nextVelocity);
            map.put(particle, p);
        }
        return map;
    }

    protected void initPopulation() {
        int id = 0;
        while (this.population.size() < this.size) {
            Particle particle = this.particleBuilder.build();
            particle.setId(id++);
            Genotype genotype = particle.getGenotype();
            if (!(genotype instanceof DoubleGenotype)) {
                throw new IncompatibilityException("MOPSO is restricted to " + DoubleGenotype.class + ", current Genotype is: " + genotype.getClass());
            }
            this.population.add(particle);
        }
    }

    protected void updateLeaders(Archive leaders, Population population) {
        leaders.update(population);
    }

    protected void updatePersonalBest(Map<Particle, Particle> next) {
        for (Map.Entry<Particle, Particle> entry : next.entrySet()) {
            Particle current;
            Particle old = entry.getKey();
            if (this.dominates(old, current = entry.getValue())) {
                current.setBest(old.getBest(), old.getBestObjectives());
                continue;
            }
            current.setBest(current.getGenotype(), current.getObjectives());
        }
    }

    protected boolean dominates(Particle old, Particle current) {
        if (old.getBest() == null) {
            return false;
        }
        Objectives oldObjectives = old.getBestObjectives();
        Objectives currentObjectives = current.getObjectives();
        return oldObjectives.dominates(currentObjectives);
    }

    protected Map<Particle, Particle> getLeaders(Archive leaders, Population population) {
        HashMap<Particle, Particle> map = new HashMap<Particle, Particle>();
        Crowding crowding = new Crowding();
        Map<Individual, Double> values = crowding.getValues(leaders);
        ArrayList<Individual> l = new ArrayList<Individual>(leaders);
        ArrayList<Individual> best = new ArrayList<Individual>();
        int i = 0;
        while (i < population.size()) {
            Individual i1 = (Individual)l.get(this.random.nextInt(l.size()));
            Individual i2 = (Individual)l.get(this.random.nextInt(l.size()));
            if (values.get(i1) >= values.get(i2)) {
                best.add(i1);
            } else {
                best.add(i2);
            }
            ++i;
        }
        i = 0;
        for (Individual individual : population) {
            Particle particle = (Particle)individual;
            Particle leader = (Particle)best.get(i++);
            map.put(particle, leader);
        }
        return map;
    }
}

