/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualCollection;
import org.opt4j.core.IndividualCollectionListener;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objective;
import org.opt4j.core.Population;
import org.opt4j.core.Range;
import org.opt4j.core.Value;
import org.opt4j.optimizer.ea.Nsga2;
import org.opt4j.start.Constant;

@Singleton
public class ScalingNsga2
extends Nsga2
implements IndividualCollectionListener,
IndividualStateListener {
    protected Map<Objective, Range> objectiveRanges = new ConcurrentHashMap<Objective, Range>();

    @Inject
    public ScalingNsga2(Rand random, @Constant(value="tournament", namespace=ScalingNsga2.class) int tournament, Population population) {
        super(random, tournament);
        population.addListener(this);
    }

    @Override
    protected void calcDistance(List<Integer> list) {
        if (list.size() < 3) {
            return;
        }
        for (int e : list) {
            this.dist[e] = 0.0;
        }
        if (this.m == null) {
            this.m = this.ind[list.get(0)].getObjectives().array().length;
        }
        Objective[] objectives = new Objective[this.m.intValue()];
        int h = 0;
        for (Map.Entry entry : this.ind[list.get(0)].getObjectives()) {
            objectives[h] = (Objective)entry.getKey();
            ++h;
        }
        int i = 0;
        while (i < this.m) {
            Collections.sort(list, new Nsga2.DimensionSort(i));
            this.dist[list.get((int)0).intValue()] = Double.MAX_VALUE;
            this.dist[list.get((int)(list.size() - 1)).intValue()] = Double.MAX_VALUE;
            int j = 1;
            while (j < list.size() - 1) {
                double p = this.ind[list.get(j - 1)].getObjectives().array()[i];
                double n = this.ind[list.get(j + 1)].getObjectives().array()[i];
                int n2 = list.get(j);
                this.dist[n2] = this.dist[n2] + (n - p) / (this.objectiveRanges.get(objectives[i]).getMax() - this.objectiveRanges.get(objectives[i]).getMin());
                ++j;
            }
            ++i;
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer p, Integer q) {
                double qv;
                double pv = ScalingNsga2.this.dist[p];
                if (pv - (qv = ScalingNsga2.this.dist[q]) > 0.0) {
                    return -1;
                }
                if (qv - pv > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void individualAdded(IndividualCollection collection, Individual individual) {
    }

    @Override
    public void individualRemoved(IndividualCollection collection, Individual individual) {
        for (Map.Entry entry : individual.getObjectives()) {
            Range range = this.objectiveRanges.get(entry.getKey());
            if (range == null || entry.getValue().getDouble().doubleValue() != range.getMin() && entry.getValue().getDouble().doubleValue() != range.getMax()) continue;
            double currentMin = range.getMin();
            double currentMax = range.getMax();
            boolean currentMinStillExists = false;
            boolean currentMaxStillExists = false;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Individual individual2 : collection) {
                Value<?> v = individual2.getObjectives().get((Objective)entry.getKey());
                if (v.getDouble() > max) {
                    max = v.getDouble();
                }
                if (v.getDouble() < min) {
                    min = v.getDouble();
                }
                if (v.getDouble() == currentMin) {
                    currentMinStillExists = true;
                }
                if (v.getDouble() == currentMax) {
                    currentMaxStillExists = true;
                }
                if (currentMaxStillExists && currentMinStillExists) break;
            }
            if (currentMaxStillExists && currentMinStillExists) continue;
            this.objectiveRanges.remove(entry.getKey());
            this.objectiveRanges.put((Objective)entry.getKey(), new Range(min, max));
        }
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        if (!individual.isEvaluated()) {
            return;
        }
        for (Map.Entry entry : individual.getObjectives()) {
            Range range = this.objectiveRanges.get(entry.getKey());
            if (range == null) {
                Range r = new Range(entry.getValue().getDouble(), entry.getValue().getDouble());
                this.objectiveRanges.put((Objective)entry.getKey(), r);
                continue;
            }
            if (entry.getValue().getDouble() < range.getMin()) {
                range.setMin(entry.getValue().getDouble());
                continue;
            }
            if (!(entry.getValue().getDouble() > range.getMax())) continue;
            range.setMax(entry.getValue().getDouble());
        }
    }
}

