/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.copy.Copy;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.operator.mutate.Mutate;
import org.opt4j.optimizer.ea.Coupler;
import org.opt4j.optimizer.ea.CrossoverRate;
import org.opt4j.optimizer.ea.Pair;

public class Mating {
    protected final Crossover<Genotype> crossover;
    protected final Mutate<Genotype> mutate;
    protected final Copy<Genotype> copy;
    protected final Coupler coupler;
    protected final CrossoverRate crossoverRate;
    protected final Random random;
    protected final IndividualBuilder individualBuilder;

    @Inject
    public Mating(Crossover<Genotype> crossover, Mutate<Genotype> mutate, Copy<Genotype> copy, Coupler coupler, CrossoverRate crossoverRate, Rand random, IndividualBuilder individualBuilder) {
        this.crossover = crossover;
        this.mutate = mutate;
        this.copy = copy;
        this.coupler = coupler;
        this.crossoverRate = crossoverRate;
        this.random = random;
        this.individualBuilder = individualBuilder;
    }

    public Collection<Individual> getOffspring(int size, Collection<Individual> parents) {
        ArrayList<Individual> offspring = new ArrayList<Individual>();
        Collection<Pair<Individual>> couples = this.coupler.getCouples((int)Math.ceil((double)size / 2.0), new ArrayList<Individual>(parents));
        for (Pair<Individual> couple : couples) {
            boolean crossover = this.random.nextDouble() <= this.crossoverRate.get();
            Individual parent1 = couple.getFirst();
            Individual parent2 = couple.getSecond();
            Pair<Individual> i = this.mate(parent1, parent2, crossover);
            Individual i1 = i.getFirst();
            Individual i2 = i.getSecond();
            offspring.add(i1);
            if (offspring.size() >= size) continue;
            offspring.add(i2);
        }
        return offspring;
    }

    private Pair<Individual> mate(Individual parent1, Individual parent2, boolean doCrossover) {
        Genotype o2;
        Genotype o1;
        Genotype p1 = parent1.getGenotype();
        Genotype p2 = parent2.getGenotype();
        if (doCrossover) {
            Pair<Genotype> offspring = this.crossover.crossover(p1, p2);
            o1 = offspring.getFirst();
            o2 = offspring.getSecond();
        } else {
            o1 = this.copy.copy(p1);
            o2 = this.copy.copy(p2);
        }
        this.mutate.mutate(o1);
        this.mutate.mutate(o2);
        Individual i1 = this.individualBuilder.build(o1);
        Individual i2 = this.individualBuilder.build(o2);
        Pair<Individual> individuals = new Pair<Individual>(i1, i2);
        return individuals;
    }
}

