/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import java.util.Collection;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.optimizer.ea.Mating;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class EvolutionaryAlgorithm
extends AbstractOptimizer {
    protected final int generations;
    protected final int alpha;
    protected final int lambda;
    protected final int mu;
    protected final Selector selector;
    protected final Mating mating;

    @Inject
    public EvolutionaryAlgorithm(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control, Selector selector, Mating mating, @Iterations int generations, @Constant(value="alpha", namespace=EvolutionaryAlgorithm.class) int alpha, @Constant(value="mu", namespace=EvolutionaryAlgorithm.class) int mu, @Constant(value="lambda", namespace=EvolutionaryAlgorithm.class) int lambda) {
        super(population, archive, individualBuilder, completer, control);
        this.selector = selector;
        this.mating = mating;
        this.generations = generations;
        this.alpha = alpha;
        this.mu = mu;
        this.lambda = lambda;
        if (alpha <= 0) {
            throw new IllegalArgumentException("Invalid alpha: " + alpha);
        }
        if (mu <= 0) {
            throw new IllegalArgumentException("Invalid mu: " + mu);
        }
        if (lambda <= 0) {
            throw new IllegalArgumentException("Invalid lambda: " + lambda);
        }
    }

    @Override
    public void optimize() throws TerminationException, StopException {
        this.selector.init(this.alpha + this.lambda);
        while (this.population.size() < this.alpha) {
            this.population.add(this.individualBuilder.build());
        }
        this.nextIteration();
        int g = 0;
        while (g < this.generations) {
            Collection<Individual> parents = this.selector.getParents(this.mu, this.population);
            Collection<Individual> offspring = this.mating.getOffspring(this.lambda, parents);
            this.population.addAll((Collection<? extends Individual>)offspring);
            this.completer.complete(offspring);
            Collection<Individual> lames = this.selector.getLames(this.lambda, this.population);
            this.population.removeAll(lames);
            this.nextIteration();
            ++g;
        }
    }
}

