/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.de;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Iterations;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.algebra.Add;
import org.opt4j.operator.algebra.Algebra;
import org.opt4j.operator.algebra.Index;
import org.opt4j.operator.algebra.Mult;
import org.opt4j.operator.algebra.Sub;
import org.opt4j.operator.algebra.Term;
import org.opt4j.operator.algebra.Var;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.optimizer.ea.Pair;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class DifferentialEvolution
extends AbstractOptimizer {
    protected final double scalingFactor;
    protected final int generations;
    protected final int alpha;
    protected final Algebra<Genotype> algebra;
    protected final Crossover<Genotype> crossover;
    protected final Selector selector;
    protected final Random random;

    @Inject
    public DifferentialEvolution(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control, Algebra<Genotype> algebra, Selector selector, Rand random, Crossover<Genotype> crossover, @Iterations int generations, @Constant(value="alpha", namespace=DifferentialEvolution.class) int alpha, @Constant(value="scalingFactor", namespace=DifferentialEvolution.class) double scalingFactor) {
        super(population, archive, individualBuilder, completer, control);
        this.algebra = algebra;
        this.selector = selector;
        this.random = random;
        this.crossover = crossover;
        this.generations = generations;
        this.alpha = alpha;
        this.scalingFactor = scalingFactor;
    }

    @Override
    public void optimize() throws StopException, TerminationException {
        Index i0 = new Index(0);
        Index i1 = new Index(1);
        Index i2 = new Index(2);
        Var c = new Var(this.scalingFactor);
        Add term = new Add(i0, new Mult(c, new Sub(i1, i2)));
        this.selector.init(2 * this.alpha);
        while (this.population.size() < this.alpha) {
            this.population.add(this.individualBuilder.build());
        }
        this.nextIteration();
        int i = 0;
        while (i < this.generations) {
            HashMap<Individual, Individual> relation = new HashMap<Individual, Individual>();
            ArrayList<Individual> list = new ArrayList<Individual>(this.population);
            for (Individual individual : this.population) {
                Individual offspring = this.createOffspring(individual, list, term);
                relation.put(individual, offspring);
            }
            this.population.addAll(relation.values());
            this.completer.complete(this.population);
            for (Map.Entry entry : relation.entrySet()) {
                Individual parent = (Individual)entry.getKey();
                Individual offspring = (Individual)entry.getValue();
                if (!parent.getObjectives().weaklyDominates(offspring.getObjectives())) continue;
                this.population.remove(offspring);
            }
            Collection<Individual> collection = this.selector.getLames(this.population.size() - this.alpha, this.population);
            this.population.removeAll(collection);
            this.nextIteration();
            ++i;
        }
    }

    protected Individual createOffspring(Individual parent, List<Individual> individuals, Term term) {
        Triple triple = this.getTriple(parent, individuals);
        Genotype g0 = triple.getFirst().getGenotype();
        Genotype g1 = triple.getSecond().getGenotype();
        Genotype g2 = triple.getThird().getGenotype();
        Genotype result = this.algebra.algebra(term, g0, g1, g2);
        Pair<Genotype> g = this.crossover.crossover(result, parent.getGenotype());
        Individual i = this.random.nextBoolean() ? this.individualBuilder.build(g.getFirst()) : this.individualBuilder.build(g.getSecond());
        return i;
    }

    protected Triple getTriple(Individual parent, List<Individual> individuals) {
        individuals.remove(parent);
        Individual ind0 = individuals.remove(this.random.nextInt(individuals.size()));
        Individual ind1 = individuals.remove(this.random.nextInt(individuals.size()));
        Individual ind2 = individuals.remove(this.random.nextInt(individuals.size()));
        Triple triple = new Triple(ind0, ind1, ind2);
        individuals.add(parent);
        individuals.add(ind0);
        individuals.add(ind1);
        individuals.add(ind2);
        return triple;
    }

    protected static class Triple {
        protected final Individual first;
        protected final Individual second;
        protected final Individual third;

        public Triple(Individual first, Individual second, Individual third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public Individual getFirst() {
            return this.first;
        }

        public Individual getSecond() {
            return this.second;
        }

        public Individual getThird() {
            return this.third;
        }
    }
}

