/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.neighbor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.neighbor.Neighbor;
import org.opt4j.operator.neighbor.NeighborBoolean;
import org.opt4j.operator.neighbor.NeighborComposite;
import org.opt4j.operator.neighbor.NeighborDouble;
import org.opt4j.operator.neighbor.NeighborGeneric;
import org.opt4j.operator.neighbor.NeighborInteger;
import org.opt4j.operator.neighbor.NeighborPermutation;

@Singleton
public class NeighborGenericImplementation
extends AbstractGenericOperator<Neighbor<Genotype>>
implements NeighborGeneric {
    @Inject
    protected NeighborGenericImplementation(NeighborHolder holder) {
        this(holder.get());
    }

    public NeighborGenericImplementation(Collection<Neighbor<?>> neighbors) {
        for (Neighbor<?> neighbor : neighbors) {
            this.addOperator(neighbor);
        }
    }

    @Override
    public void neighbor(Genotype genotype) {
        Neighbor neighbor = (Neighbor)this.getOperator(genotype.getClass());
        neighbor.neighbor(genotype);
    }

    static class NeighborHolder
    extends AbstractGenericOperator.OperatorHolder<Neighbor<?>> {
        @Inject
        protected NeighborHolder(NeighborBoolean neighborBoolean, NeighborDouble neighborDouble, NeighborInteger neighborInteger, NeighborPermutation neighborPermutation, NeighborComposite neighborComposite) {
            this.add(neighborBoolean);
            this.add(neighborDouble);
            this.add(neighborInteger);
            this.add(neighborPermutation);
            this.add(neighborComposite);
        }
    }
}

