/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.genotype.IntegerGenotype;
import org.opt4j.operator.mutate.MutateInteger;
import org.opt4j.operator.mutate.MutationRate;

public class MutateIntegerRandom
implements MutateInteger {
    protected final Random random;
    protected final MutationRate mutationRate;

    @Inject
    public MutateIntegerRandom(Rand random, MutationRate mutationRate) {
        this.random = random;
        this.mutationRate = mutationRate;
    }

    @Override
    public void mutate(IntegerGenotype genotype) {
        int size = genotype.size();
        int i = 0;
        while (i < size) {
            if (this.random.nextDouble() < this.mutationRate.get()) {
                int lb = genotype.getLowerBound(i);
                int ub = genotype.getUpperBound(i);
                int value = this.random.nextInt(ub - lb + 1) + lb;
                genotype.set(i, value);
            }
            ++i;
        }
    }
}

