/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.mutate.Mutate;
import org.opt4j.operator.mutate.MutateBoolean;
import org.opt4j.operator.mutate.MutateComposite;
import org.opt4j.operator.mutate.MutateDouble;
import org.opt4j.operator.mutate.MutateGeneric;
import org.opt4j.operator.mutate.MutateInteger;
import org.opt4j.operator.mutate.MutatePermutation;

@Singleton
public class MutateGenericImplementation
extends AbstractGenericOperator<Mutate<Genotype>>
implements MutateGeneric {
    @Inject
    protected MutateGenericImplementation(MutateHolder holder) {
        this(holder.get());
    }

    public MutateGenericImplementation(Collection<Mutate<?>> mutates) {
        for (Mutate<?> mutate : mutates) {
            this.addOperator(mutate);
        }
    }

    @Override
    public void mutate(Genotype genotype) {
        Mutate mutate = (Mutate)this.getOperator(genotype.getClass());
        mutate.mutate(genotype);
    }

    static class MutateHolder
    extends AbstractGenericOperator.OperatorHolder<Mutate<?>> {
        @Inject
        protected MutateHolder(MutateBoolean mutateBoolean, MutateDouble mutateDouble, MutateInteger mutateInteger, MutateComposite mutateComposite, MutatePermutation mutatePermutation) {
            this.add(mutateBoolean);
            this.add(mutateDouble);
            this.add(mutateInteger);
            this.add(mutateComposite);
            this.add(mutatePermutation);
        }
    }
}

