/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.operator.mutate.MutateDoubleElementwise;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.start.Constant;

public class MutateDoublePolynomial
extends MutateDoubleElementwise {
    protected final double eta;

    @Inject
    public MutateDoublePolynomial(MutationRate mutationRate, Rand random, NormalizeDouble normalize, @Constant(value="eta", namespace=MutateDoublePolynomial.class) double eta) {
        super(mutationRate, random, normalize);
        this.eta = eta;
    }

    @Override
    protected double mutateElement(double x) {
        if (this.random.nextDouble() < this.mutationRate.get()) {
            double u = this.random.nextDouble();
            double delta = 0.0;
            double lb = 0.0;
            double ub = 1.0;
            double diff = ub - lb;
            if (u < 0.5) {
                double m = 1.0 - (x - lb) / diff;
                double b = 2.0 * u + (1.0 - 2.0 * u) * Math.pow(m, this.eta + 1.0);
                delta = Math.pow(b, 1.0 / (this.eta + 1.0)) - 1.0;
            } else {
                double m = 1.0 - (ub - x) / diff;
                double b = 2.0 * (1.0 - u) + 2.0 * (u - 0.5) * Math.pow(m, this.eta + 1.0);
                delta = 1.0 - Math.pow(b, 1.0 / (this.eta + 1.0));
            }
            return x + delta * diff;
        }
        return x;
    }
}

