/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.operator.mutate.MutateDoubleElementwise;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.start.Constant;

public class MutateDoubleGauss
extends MutateDoubleElementwise {
    protected final double sigma;

    @Inject
    public MutateDoubleGauss(MutationRate mutationRate, Rand random, NormalizeDouble normalize, @Constant(value="sigma", namespace=MutateDoubleGauss.class) double sigma) {
        super(mutationRate, random, normalize);
        this.sigma = sigma;
    }

    @Override
    protected double mutateElement(double element) {
        if (this.random.nextDouble() < this.mutationRate.get()) {
            element += this.mutationRate.get() + this.sigma * this.random.nextGaussian();
        }
        return element;
    }
}

