/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.operator.mutate.MutationRate;

@Singleton
public class AdaptiveMutationRate
implements MutationRate,
IndividualStateListener {
    protected boolean isInit = false;
    protected double rate = 0.0;
    protected final IndividualBuilder individualBuilder;

    @Inject
    public AdaptiveMutationRate(IndividualBuilder individualBuilder) {
        this.individualBuilder = individualBuilder;
    }

    @Inject
    public void init() {
        this.individualBuilder.addIndividualStateListener(this);
    }

    @Override
    public double get() {
        return this.rate;
    }

    @Override
    public void set(double value) {
        this.rate = value;
    }

    @Override
    public synchronized void inidividualStateChanged(Individual individual) {
        if (!this.isInit && individual.getState() != Individual.State.EMPTY) {
            int size = individual.getGenotype().size();
            if (size > 0) {
                this.set(1.0 / (double)individual.getGenotype().size());
            }
            this.individualBuilder.removeIndividualStateListener(this);
            this.isInit = true;
        }
    }
}

