/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.diversity;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.diversity.Diversity;
import org.opt4j.operator.diversity.DiversityBoolean;
import org.opt4j.operator.diversity.DiversityComposite;
import org.opt4j.operator.diversity.DiversityDouble;
import org.opt4j.operator.diversity.DiversityGeneric;
import org.opt4j.operator.diversity.DiversityInteger;
import org.opt4j.operator.diversity.DiversityPermutation;

@Singleton
public class DiversityGenericImplementation
extends AbstractGenericOperator<Diversity<Genotype>>
implements DiversityGeneric {
    @Inject
    protected DiversityGenericImplementation(DiversityHolder holder) {
        this(holder.get());
    }

    public DiversityGenericImplementation(Collection<Diversity<?>> diversities) {
        for (Diversity<?> diversity : diversities) {
            this.addOperator(diversity);
        }
    }

    @Override
    public double diversity(Genotype a, Genotype b) {
        Diversity diversity = (Diversity)this.getOperator(a.getClass());
        return diversity.diversity(a, b);
    }

    static class DiversityHolder
    extends AbstractGenericOperator.OperatorHolder<Diversity<?>> {
        @Inject
        protected DiversityHolder(DiversityBoolean diversityBoolean, DiversityDouble diversityDouble, DiversityInteger diversityInteger, DiversityPermutation diversityPermutation, DiversityComposite diversityComposite) {
            this.add(diversityBoolean);
            this.add(diversityDouble);
            this.add(diversityInteger);
            this.add(diversityPermutation);
            this.add(diversityComposite);
        }
    }
}

