/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.crossover;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.genotype.ListGenotype;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.optimizer.ea.Pair;

public abstract class CrossoverListRate<G extends ListGenotype<?>>
implements Crossover<G> {
    protected final Random random;
    protected final double rate;

    @Inject
    public CrossoverListRate(double rate, Rand random) {
        this.rate = rate;
        this.random = random;
    }

    @Override
    public Pair<G> crossover(G p1, G p2) {
        ListGenotype o1 = (ListGenotype)p1.newInstance();
        ListGenotype o2 = (ListGenotype)p2.newInstance();
        int size = p1.size();
        boolean select = this.random.nextBoolean();
        int i = 0;
        while (i < size) {
            if (this.random.nextDouble() < this.rate) {
                boolean bl = select = !select;
            }
            if (select) {
                o1.add(p1.get(i));
                o2.add(p2.get(i));
            } else {
                o1.add(p2.get(i));
                o2.add(p1.get(i));
            }
            ++i;
        }
        Pair<ListGenotype> offspring = new Pair<ListGenotype>(o1, o2);
        return offspring;
    }
}

