/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.algebra;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.algebra.Algebra;
import org.opt4j.operator.algebra.AlgebraComposite;
import org.opt4j.operator.algebra.AlgebraDouble;
import org.opt4j.operator.algebra.AlgebraGeneric;
import org.opt4j.operator.algebra.Term;

@Singleton
public class AlgebraGenericImplementation
extends AbstractGenericOperator<Algebra<Genotype>>
implements AlgebraGeneric {
    @Inject
    protected AlgebraGenericImplementation(AlgebraHolder holder) {
        this(holder.get());
    }

    public AlgebraGenericImplementation(Collection<Algebra<?>> algebras) {
        for (Algebra<?> algebra : algebras) {
            this.addOperator(algebra);
        }
    }

    @Override
    public Genotype algebra(Term term, Genotype ... genotypes) {
        Algebra algebra = (Algebra)this.getOperator(genotypes[0].getClass());
        return algebra.algebra(term, genotypes);
    }

    static class AlgebraHolder
    extends AbstractGenericOperator.OperatorHolder<Algebra<?>> {
        @Inject
        protected AlgebraHolder(AlgebraDouble algebraDouble, AlgebraComposite algebraComposite) {
            this.add(algebraDouble);
            this.add(algebraComposite);
        }
    }
}

