/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator;

import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opt4j.core.IncompatibilityException;
import org.opt4j.core.optimizer.Operator;
import org.opt4j.core.problem.Genotype;
import org.opt4j.operator.Apply;
import org.opt4j.operator.GenericOperator;
import org.opt4j.operator.Parameters;

public class AbstractGenericOperator<O extends Operator<?>>
implements GenericOperator<O> {
    protected SortedMap<Class<? extends Genotype>, O> operators = new TreeMap<Class<Genotype>, O>(new ClassComparator());

    @Override
    public void addOperator(O operator) {
        Class<Genotype> clazz = AbstractGenericOperator.getTarget(operator);
        this.addOperator(clazz, operator);
    }

    protected void addOperator(Class<? extends Genotype> clazz, O operator) {
        this.operators.put(clazz, operator);
    }

    @Override
    public O getOperator(Class<? extends Genotype> clazz) {
        Operator operator = (Operator)this.operators.get(clazz);
        if (operator != null) {
            return (O)operator;
        }
        for (Map.Entry<Class<Genotype>, O> entry : this.operators.entrySet()) {
            Class<? extends Genotype> c = entry.getKey();
            if (!c.isAssignableFrom(clazz)) continue;
            operator = (Operator)entry.getValue();
            this.addOperator(clazz, operator);
            return (O)operator;
        }
        throw new IncompatibilityException("No handler found for " + clazz + " in " + this.getClass());
    }

    @Override
    public Collection<O> getOperators() {
        return this.operators.values();
    }

    protected static <O> Class<? extends Genotype> getTarget(O operator) {
        Apply apply = operator.getClass().getAnnotation(Apply.class);
        if (apply != null) {
            return apply.value();
        }
        Type type = Parameters.getType(Operator.class, operator, "G");
        if (type != null) {
            Class<Genotype> target = Parameters.getClass(type).asSubclass(Genotype.class);
            return target;
        }
        throw new IllegalArgumentException("No target specified for the operator " + operator.getClass().getName() + ". Either parameterize the Operator or use the " + Apply.class.getName() + " annotation to specify a target.");
    }

    protected class ClassComparator
    implements Comparator<Class<? extends Genotype>> {
        protected ClassComparator() {
        }

        @Override
        public int compare(Class<? extends Genotype> arg0, Class<? extends Genotype> arg1) {
            if (arg0.equals(arg1)) {
                return 0;
            }
            if (arg0.isAssignableFrom(arg1)) {
                return 1;
            }
            if (arg1.isAssignableFrom(arg0)) {
                return -1;
            }
            return arg0.getCanonicalName().compareTo(arg1.getCanonicalName());
        }
    }

    protected static class OperatorHolder<P> {
        @Inject(optional=true)
        protected Set<P> operators = new HashSet<P>();
        protected List<P> list = new ArrayList<P>();
        protected boolean init = false;

        protected OperatorHolder() {
        }

        public synchronized Collection<P> get() {
            if (!this.init) {
                for (P operator : this.operators) {
                    this.add(operator);
                }
                this.init = true;
            }
            return this.list;
        }

        public void add(P operator) {
            this.list.add(operator);
        }
    }
}

