/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.genotype;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.opt4j.core.problem.Genotype;
import org.opt4j.genotype.Bounds;
import org.opt4j.genotype.IntegerGenotype;
import org.opt4j.genotype.MapGenotype;

public class IntegerMapGenotype<K>
extends IntegerGenotype
implements MapGenotype<K, Integer> {
    protected final List<K> list;
    private static final long serialVersionUID = 1L;

    public IntegerMapGenotype(List<K> list, Bounds<Integer> bounds) {
        super(bounds);
        this.list = list;
    }

    public IntegerMapGenotype(List<K> list, int lowerBound, int upperBound) {
        super(lowerBound, upperBound);
        this.list = list;
    }

    public void init(Random random) {
        super.init(random, this.list.size());
    }

    @Override
    public void init(Random random, int n) {
        throw new UnsupportedOperationException("Use method init(Random) instead");
    }

    @Override
    public boolean containsKey(K key) {
        return this.list.contains(key);
    }

    @Override
    public Integer getValue(K key) {
        int i = this.list.indexOf(key);
        return (Integer)this.get(i);
    }

    @Override
    public void setValue(K key, Integer value) {
        int i = this.list.indexOf(key);
        while (this.size() <= i) {
            this.add((Integer)this.bounds.getLowerBound(i));
        }
        this.set(i, value);
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            Constructor<?> cstr = this.getClass().getConstructor(List.class, Bounds.class);
            return (G)((Genotype)cstr.newInstance(this.list, this.bounds));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        String s = "[";
        int i = 0;
        while (i < this.size()) {
            K key = this.list.get(i);
            double value = ((Integer)this.get(i)).intValue();
            s = String.valueOf(s) + key + "=" + value + ";";
            ++i;
        }
        return String.valueOf(s) + "]";
    }

    @Override
    public int getIndexOf(K key) {
        return this.list.indexOf(key);
    }

    @Override
    public Collection<K> getKeys() {
        return Collections.unmodifiableList(this.list);
    }
}

