/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.genotype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opt4j.core.problem.Genotype;

public class CompositeGenotype<K, V extends Genotype>
implements Genotype,
Iterable<Map.Entry<K, V>> {
    protected final Map<K, V> map = new HashMap();

    public CompositeGenotype() {
    }

    public CompositeGenotype(Map<K, V> map) {
        this();
        this.map.putAll(map);
    }

    @Override
    public int size() {
        int sum = 0;
        for (Genotype element : this.map.values()) {
            sum += element.size();
        }
        return sum;
    }

    public <G> G get(Object key) {
        Genotype value = (Genotype)this.map.get(key);
        return (G)value;
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            return (G)((Genotype)this.getClass().newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String s = "[";
        for (Map.Entry<K, V> entry : this) {
            K key = entry.getKey();
            Genotype value = (Genotype)entry.getValue();
            s = String.valueOf(s) + key + "=" + value + ";";
        }
        return String.valueOf(s) + "]";
    }
}

